/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.choices.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacetAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class PropertyChoicesFacetViaMethod
extends PropertyChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesClass;
    private final ObjectAdapterProvider adapterProvider;

    public PropertyChoicesFacetViaMethod(Method method, Class<?> choicesClass, FacetHolder holder, SpecificationLoader specificationLookup, ObjectAdapterProvider adapterProvider) {
        super(holder, specificationLookup);
        this.method = method;
        this.choicesClass = choicesClass;
        this.adapterProvider = adapterProvider;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public Object[] getChoices(ObjectAdapter owningAdapter, SpecificationLoader specificationLookup, InteractionInitiatedBy interactionInitiatedBy) {
        Object options = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        if (options == null) {
            return null;
        }
        if (options.getClass().isArray()) {
            return ObjectExtensions.asArray(options);
        }
        ObjectSpecification specification = specificationLookup.loadSpecification(this.choicesClass);
        return CollectionUtils.getCollectionAsObjectArray(options, specification, this.getObjectAdapterProvider());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",class=" + this.choicesClass;
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProvider;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
        attributeMap.put("choicesType", this.choicesClass);
    }
}

