/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.parameter.regex;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.isis.applib.annotation.Parameter;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacetAbstract;

public class RegExFacetForParameterAnnotation
extends RegExFacetAbstract {
    private final Pattern pattern;

    public static RegExFacet create(List<Parameter> parameters, Class<?> parameterType, FacetHolder holder) {
        return parameters.stream().filter(parameter -> _Strings.emptyToNull((String)parameter.regexPattern()) != null).findFirst().map(parameter -> {
            String pattern = parameter.regexPattern();
            String replacement = parameter.regexPatternReplacement();
            int patternFlags = parameter.regexPatternFlags();
            return new RegExFacetForParameterAnnotation(pattern, patternFlags, replacement, holder);
        }).orElse(null);
    }

    private RegExFacetForParameterAnnotation(String pattern, int patternFlags, String replacement, FacetHolder holder) {
        super(pattern, patternFlags, replacement, holder);
        this.pattern = Pattern.compile(pattern, patternFlags);
    }

    @Override
    public boolean doesNotMatch(String text) {
        return text == null || !this.pattern.matcher(text).matches();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("pattern", this.pattern);
    }
}

