/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.bigdecimal.javaxvaldigits;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.constraints.Digits;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.param.bigdecimal.javaxvaldigits.BigDecimalFacetOnParameterFromJavaxValidationDigitsAnnotation;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;

public class BigDecimalFacetOnParameterFromJavaxValidationAnnotationFactory
extends FacetFactoryAbstract {
    public BigDecimalFacetOnParameterFromJavaxValidationAnnotationFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        Method method = processParameterContext.getMethod();
        int paramNum = processParameterContext.getParamNum();
        if (BigDecimal.class != method.getParameterTypes()[paramNum]) {
            return;
        }
        List<Digits> digitsAnnots = Annotations.getAnnotations(method, paramNum, Digits.class);
        if (digitsAnnots.size() > 0) {
            FacetUtil.addFacet(this.create(digitsAnnots.get(0), (FacetHolder)processParameterContext.getFacetHolder()));
        }
    }

    private BigDecimalValueFacet create(Digits annotation, FacetHolder holder) {
        int length = annotation.integer() + annotation.fraction();
        int scale = annotation.fraction();
        return new BigDecimalFacetOnParameterFromJavaxValidationDigitsAnnotation(holder, length, scale);
    }
}

