/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.objectvalue.regex;

import javax.validation.constraints.Pattern;
import org.apache.isis.applib.services.wrapper.events.ValidityEvent;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.MultipleValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.objectvalue.regex.RegExFacet;
import org.apache.isis.core.metamodel.interactions.ProposedHolder;
import org.apache.isis.core.metamodel.interactions.ValidityContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public abstract class RegExFacetAbstract
extends MultipleValueFacetAbstract
implements RegExFacet {
    private final String regexp;
    private final int patternFlags;
    private final String message;

    public static Class<? extends Facet> type() {
        return RegExFacet.class;
    }

    public RegExFacetAbstract(String regexp, int patternFlags, String message, FacetHolder holder) {
        super(RegExFacetAbstract.type(), holder);
        this.regexp = regexp;
        this.patternFlags = patternFlags;
        this.message = message != null ? message : "Doesn't match pattern";
    }

    private static int asMask(Pattern.Flag[] flags) {
        int mask = 0;
        for (Pattern.Flag flag : flags) {
            mask |= flag.getValue();
        }
        return mask;
    }

    public RegExFacetAbstract(String regexp, Pattern.Flag[] flags, String message, FacetHolder holder) {
        this(regexp, RegExFacetAbstract.asMask(flags), message, holder);
    }

    @Override
    public String regexp() {
        return this.regexp;
    }

    @Override
    public int patternFlags() {
        return this.patternFlags;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public String invalidates(ValidityContext<? extends ValidityEvent> context) {
        if (!(context instanceof ProposedHolder)) {
            return null;
        }
        ProposedHolder proposedHolder = (ProposedHolder)((Object)context);
        ManagedObject proposedArgument = proposedHolder.getProposed();
        if (proposedArgument == null) {
            return null;
        }
        String titleString = proposedArgument.titleString();
        if (!this.doesNotMatch(titleString)) {
            return null;
        }
        return this.message();
    }
}

