/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.value.annotcfg;

import org.apache.isis.applib.annotation.Value;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.facets.object.value.annotcfg.ValueFacetAnnotation;
import org.apache.isis.core.metamodel.facets.object.value.annotcfg.ValueFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderUtil;

public class ValueFacetAnnotationOrConfigurationFactory
extends FacetFactoryAbstract {
    public ValueFacetAnnotationOrConfigurationFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContaxt) {
        FacetUtil.addFacet(this.create(processClassContaxt.getCls(), (FacetHolder)processClassContaxt.getFacetHolder()));
    }

    private ValueFacet create(Class<?> cls, FacetHolder holder) {
        ValueFacetFromConfiguration facet;
        ValueFacetAnnotation facet2;
        Value annotation = Annotations.getAnnotation(cls, Value.class);
        if (annotation != null && (facet2 = new ValueFacetAnnotation(cls, holder, this.servicesInjector)).isValid()) {
            return facet2;
        }
        String semanticsProviderName = ValueSemanticsProviderUtil.semanticsProviderNameFromConfiguration(cls, this.getConfiguration());
        if (!_Strings.isNullOrEmpty((CharSequence)semanticsProviderName) && (facet = new ValueFacetFromConfiguration(semanticsProviderName, holder, this.servicesInjector)).isValid()) {
            return facet;
        }
        return null;
    }
}

