/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.title.methods;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleFacetViaTitleMethod
extends TitleFacetAbstract
implements ImperativeFacet {
    private static final Logger LOG = LoggerFactory.getLogger(TitleFacetViaTitleMethod.class);
    private final Method method;
    private final TranslationService translationService;
    private final String translationContext;

    public TitleFacetViaTitleMethod(Method method, TranslationService translationService, String translationContext, FacetHolder holder) {
        super(holder);
        this.method = method;
        this.translationService = translationService;
        this.translationContext = translationContext;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.UI_HINT;
    }

    @Override
    public String title(ManagedObject owningAdapter) {
        try {
            Object returnValue = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
            if (returnValue instanceof String) {
                return (String)returnValue;
            }
            if (returnValue instanceof TranslatableString) {
                TranslatableString ts = (TranslatableString)returnValue;
                return ts.translate(this.translationService, this.translationContext);
            }
            return null;
        }
        catch (RuntimeException ex) {
            LOG.warn("title failure", (Throwable)ex);
            return "Failed Title";
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

