/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.recreatable;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.isis.applib.ViewModel;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.MarkerFacetAbstract;
import org.apache.isis.core.metamodel.facets.PostConstructMethodCache;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;

public abstract class RecreatableObjectFacetAbstract
extends MarkerFacetAbstract
implements ViewModelFacet {
    private final PostConstructMethodCache postConstructMethodCache;
    private final ViewModelFacet.RecreationMechanism recreationMechanism;
    protected final ServicesInjector servicesInjector;

    public static Class<? extends Facet> type() {
        return ViewModelFacet.class;
    }

    public RecreatableObjectFacetAbstract(FacetHolder holder, ViewModelFacet.RecreationMechanism recreationMechanism, PostConstructMethodCache postConstructMethodCache, ServicesInjector servicesInjector) {
        super(RecreatableObjectFacetAbstract.type(), holder);
        this.postConstructMethodCache = postConstructMethodCache;
        this.recreationMechanism = recreationMechanism;
        this.servicesInjector = servicesInjector;
    }

    @Override
    public boolean isCloneable(Object pojo) {
        return pojo != null && pojo instanceof ViewModel.Cloneable;
    }

    @Override
    public boolean isImplicitlyImmutable() {
        ObjectSpecificationDefault objectSpec;
        Class<?> correspondingClass;
        FacetHolder facetHolder = this.getFacetHolder();
        return !(facetHolder instanceof ObjectSpecificationDefault) || !ViewModel.Cloneable.class.isAssignableFrom(correspondingClass = (objectSpec = (ObjectSpecificationDefault)facetHolder).getCorrespondingClass());
    }

    @Override
    public Object clone(Object pojo) {
        ViewModel.Cloneable viewModelCloneable = (ViewModel.Cloneable)pojo;
        return viewModelCloneable.clone();
    }

    @Override
    public ViewModelFacet.RecreationMechanism getRecreationMechanism() {
        return this.recreationMechanism;
    }

    @Override
    public final Object instantiate(Class<?> viewModelClass, String mementoStr) {
        if (this.getRecreationMechanism() == ViewModelFacet.RecreationMechanism.INITIALIZES) {
            throw new IllegalStateException("This view model instantiates rather than initializes");
        }
        Object viewModelPojo = this.doInstantiate(viewModelClass, mementoStr);
        this.servicesInjector.injectInto(viewModelPojo);
        this.invokePostConstructMethod(viewModelPojo);
        return viewModelPojo;
    }

    protected Object doInstantiate(Class<?> viewModelClass, String mementoStr) {
        throw new IllegalStateException("doInstantiate() must be overridden if RecreationMechanism is INSTANTIATES");
    }

    @Override
    public final void initialize(Object viewModelPojo, String mementoStr) {
        if (this.getRecreationMechanism() == ViewModelFacet.RecreationMechanism.INSTANTIATES) {
            throw new IllegalStateException("This view model instantiates rather than initializes");
        }
        this.doInitialize(viewModelPojo, mementoStr);
        this.invokePostConstructMethod(viewModelPojo);
    }

    protected void doInitialize(Object viewModelPojo, String mementoStr) {
        throw new IllegalStateException("doInitialize() must be overridden if RecreationMechanism is INITIALIZE");
    }

    private void invokePostConstructMethod(Object viewModel) {
        Method postConstructMethod = this.postConstructMethodCache.postConstructMethodFor(viewModel);
        if (postConstructMethod != null) {
            MethodExtensions.invoke(postConstructMethod, viewModel);
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("recreationMechanism", (Object)this.recreationMechanism);
    }
}

