/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.parseable;

import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;

public final class ParserUtil {
    public static final String PARSER_NAME_KEY_PREFIX = "isis.reflector.java.facets.parser.";
    public static final String PARSER_NAME_KEY_SUFFIX = ".parserName";

    private ParserUtil() {
    }

    public static String parserNameFromConfiguration(Class<?> type, IsisConfiguration configuration) {
        String key = PARSER_NAME_KEY_PREFIX + type.getCanonicalName() + PARSER_NAME_KEY_SUFFIX;
        String parserName = configuration.getString(key);
        return !_Strings.isNullOrEmpty((CharSequence)parserName) ? parserName : null;
    }

    public static Class<? extends Parser<?>> parserOrNull(Class<?> candidateClass, String classCandidateName) {
        Class type = candidateClass != null ? (Class)_Casts.uncheckedCast(ClassUtil.implementingClassOrNull(candidateClass.getName(), Parser.class, FacetHolder.class)) : null;
        return type != null ? type : (Class)_Casts.uncheckedCast(ClassUtil.implementingClassOrNull(classCandidateName, Parser.class, FacetHolder.class));
    }
}

