/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.navparent.annotation;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.navparent.method.NavigableParentFacetMethod;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class NavigableParentAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    PersistenceSessionServiceInternal adapterManager;

    public NavigableParentAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Method method;
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        List<Annotations.Evaluator<PropertyLayout>> evaluators = Annotations.firstEvaluatorsInHierarchyHaving(cls, PropertyLayout.class, NavigableParentAnnotationFacetFactory::isNavigableParentFlagSet);
        if (_NullSafe.isEmpty(evaluators)) {
            return;
        }
        if (evaluators.size() > 1) {
            throw new RuntimeException("unable to determine navigable parent due to ambiguity");
        }
        Annotations.Evaluator<PropertyLayout> parentEvaluator = evaluators.get(0);
        if (parentEvaluator instanceof Annotations.MethodEvaluator) {
            method = ((Annotations.MethodEvaluator)parentEvaluator).getMethod();
        } else if (parentEvaluator instanceof Annotations.FieldEvaluator) {
            method = ((Annotations.FieldEvaluator)parentEvaluator).getGetter(cls).orElse(null);
            if (method == null) {
                return;
            }
        } else {
            return;
        }
        try {
            FacetUtil.addFacet(new NavigableParentFacetMethod(method, (FacetHolder)facetHolder));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static boolean isNavigableParentFlagSet(Annotations.Evaluator<PropertyLayout> evaluator) {
        return evaluator.getAnnotation().navigable().isParent();
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                Annotations.FieldEvaluator fieldEvaluator;
                Class<?> cls = objectSpec.getCorrespondingClass();
                List<Annotations.Evaluator<PropertyLayout>> evaluators = Annotations.firstEvaluatorsInHierarchyHaving(cls, PropertyLayout.class, x$0 -> NavigableParentAnnotationFacetFactory.isNavigableParentFlagSet(x$0));
                if (_NullSafe.isEmpty(evaluators)) {
                    return true;
                }
                if (evaluators.size() > 1) {
                    validationFailures.add("%s: conflict for determining a strategy for retrieval of (navigable) parent for class, contains multiple annotations '@%s' having navigable=PARENT, while at most one is allowed.", objectSpec.getIdentifier().getClassName(), PropertyLayout.class.getName());
                    return true;
                }
                Annotations.Evaluator<PropertyLayout> parentEvaluator = evaluators.get(0);
                if (parentEvaluator instanceof Annotations.FieldEvaluator && !(fieldEvaluator = (Annotations.FieldEvaluator)parentEvaluator).getGetter(cls).isPresent()) {
                    validationFailures.add("%s: unable to determine a strategy for retrieval of (navigable) parent for class, field '%s' annotated with '@%s' having navigable=PARENT does not provide a getter.", objectSpec.getIdentifier().getClassName(), fieldEvaluator.getField().getName(), PropertyLayout.class.getName());
                }
                return true;
            }
        }));
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterManager = servicesInjector.getPersistenceSessionServiceInternal();
    }
}

