/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.ignore.javalang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.spec.InjectorMethodEvaluator;
import org.apache.isis.core.metamodel.specloader.InjectorMethodEvaluatorDefault;

public class RemoveMethodsFacetFactory
extends FacetFactoryAbstract {
    private static final String JAVA_CLASS_PREFIX = "java.";
    private final InjectorMethodEvaluator injectorMethodEvaluator = new InjectorMethodEvaluatorDefault();
    private final List<MethodAndParameterTypes> javaLangObjectMethodsToIgnore = _Lists.newArrayList();

    public RemoveMethodsFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
        Method[] methods;
        Class<Object> typeToIgnore = Object.class;
        for (Method method : methods = typeToIgnore.getMethods()) {
            this.javaLangObjectMethodsToIgnore.add(new MethodAndParameterTypes(method.getName(), method.getParameterTypes()));
        }
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        super.process(processClassContext);
        Class<?> cls = processClassContext.getCls();
        Method[] methods = cls.getMethods();
        for (Method method : methods) {
            if (method.isSynthetic() || Modifier.isAbstract(method.getModifiers())) {
                processClassContext.removeMethod(method);
            }
            if (!method.getName().equals("compareTo")) continue;
            processClassContext.removeMethod(method);
        }
        this.getSpecificationLoader().streamServiceClasses().forEach(serviceClass -> {
            Method[] methods2;
            for (Method method : methods2 = processClassContext.getCls().getMethods()) {
                if (!this.injectorMethodEvaluator.isInjectorMethodFor(method, (Class<? extends Object>)serviceClass)) continue;
                processClassContext.removeMethod(method);
            }
        });
        this.removeSuperclassMethods(processClassContext.getCls(), processClassContext);
        for (MethodAndParameterTypes mapt : this.javaLangObjectMethodsToIgnore) {
            processClassContext.removeMethod(MethodScope.OBJECT, mapt.methodName, null, mapt.methodParameters);
        }
        processClassContext.removeMethod(MethodScope.OBJECT, "init", Void.TYPE, _Constants.emptyClasses);
    }

    private void removeSuperclassMethods(Class<?> type, FacetFactory.ProcessClassContext processClassContext) {
        Method[] methods;
        if (type == null) {
            return;
        }
        if (!ClassExtensions.isJavaClass(type)) {
            this.removeSuperclassMethods(type.getSuperclass(), processClassContext);
            return;
        }
        for (Method method : methods = type.getMethods()) {
            processClassContext.removeMethod(method);
        }
    }

    public static class MethodAndParameterTypes {
        public final String methodName;
        public final Class<?>[] methodParameters;

        public MethodAndParameterTypes(String methodName, Class<?>[] methodParameters) {
            this.methodName = methodName;
            this.methodParameters = methodParameters;
        }
    }
}

