/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.grid;

import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.services.grid.GridService2;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.facets.object.layout.LayoutFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class GridFacetDefault
extends FacetAbstract
implements GridFacet {
    private final GridService2 gridService;
    private Grid grid;

    public static Class<? extends Facet> type() {
        return GridFacet.class;
    }

    public static GridFacet create(FacetHolder facetHolder, GridService2 gridService) {
        return new GridFacetDefault(facetHolder, gridService);
    }

    private GridFacetDefault(FacetHolder facetHolder, GridService2 gridService) {
        super(GridFacetDefault.type(), facetHolder, FacetAbstract.Derivation.NOT_DERIVED);
        this.gridService = gridService;
    }

    @Override
    public Grid getGrid(ManagedObject objectAdapterIfAny) {
        if (!this.gridService.supportsReloading() && this.grid != null) {
            return this.grid;
        }
        Class<?> domainClass = this.getSpecification().getCorrespondingClass();
        LayoutFacet layoutFacet = this.getFacetHolder().getFacet(LayoutFacet.class);
        String layout = layoutFacet != null && objectAdapterIfAny != null ? layoutFacet.layout(objectAdapterIfAny) : null;
        this.grid = this.load(domainClass, layout);
        return this.grid;
    }

    private Grid load(Class<?> domainClass, String layout) {
        Grid grid = this.gridService.load(domainClass, layout);
        if (grid == null) {
            grid = this.gridService.defaultGridFor(domainClass);
        }
        this.gridService.normalize(grid);
        return grid;
    }

    private ObjectSpecification getSpecification() {
        return (ObjectSpecification)this.getFacetHolder();
    }
}

