/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobjectlayout;

import java.util.List;
import java.util.Map;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.eventbus.LayoutUiEvent;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.layout.LayoutFacet;
import org.apache.isis.core.metamodel.facets.object.layout.LayoutFacetAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.util.EventUtil;

public class LayoutFacetViaDomainObjectLayoutAnnotationUsingLayoutUiEvent
extends LayoutFacetAbstract
implements LayoutFacet {
    private final Class<? extends LayoutUiEvent<?>> layoutUiEventClass;
    private final EventBusService eventBusService;

    public static Facet create(List<DomainObjectLayout> domainObjectLayouts, ServicesInjector servicesInjector, IsisConfiguration configuration, FacetHolder facetHolder) {
        return domainObjectLayouts.stream().map(DomainObjectLayout::layoutUiEvent).filter(layoutUiEvent -> EventUtil.eventTypeIsPostable(layoutUiEvent, LayoutUiEvent.Noop.class, LayoutUiEvent.Default.class, "isis.reflector.facet.domainObjectLayoutAnnotation.layoutUiEvent.postForDefault", configuration)).findFirst().map(layoutUiEvent -> {
            EventBusService eventBusService = (EventBusService)servicesInjector.lookupServiceElseFail(EventBusService.class);
            return new LayoutFacetViaDomainObjectLayoutAnnotationUsingLayoutUiEvent((Class<? extends LayoutUiEvent<?>>)layoutUiEvent, eventBusService, facetHolder);
        }).orElse(null);
    }

    public LayoutFacetViaDomainObjectLayoutAnnotationUsingLayoutUiEvent(Class<? extends LayoutUiEvent<?>> layoutUiEventClass, EventBusService eventBusService, FacetHolder holder) {
        super(holder);
        this.layoutUiEventClass = layoutUiEventClass;
        this.eventBusService = eventBusService;
    }

    @Override
    public String layout(ManagedObject owningAdapter) {
        Facet underlyingFacet;
        if (owningAdapter == null) {
            return null;
        }
        LayoutUiEvent<Object> layoutUiEvent = this.newLayoutUiEvent(owningAdapter);
        this.eventBusService.post(layoutUiEvent);
        String layout = layoutUiEvent.getLayout();
        if (layout == null && (underlyingFacet = this.getUnderlyingFacet()) instanceof LayoutFacet) {
            LayoutFacet underlyingLayoutFacet = (LayoutFacet)underlyingFacet;
            return underlyingLayoutFacet.layout(owningAdapter);
        }
        return layout;
    }

    private LayoutUiEvent<Object> newLayoutUiEvent(ManagedObject owningAdapter) {
        Object domainObject = owningAdapter.getPojo();
        return this.newLayoutUiEvent(domainObject);
    }

    private LayoutUiEvent<Object> newLayoutUiEvent(Object domainObject) {
        try {
            LayoutUiEvent<?> layoutUiEvent = this.layoutUiEventClass.newInstance();
            layoutUiEvent.setSource(domainObject);
            return layoutUiEvent;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new NonRecoverableException((Throwable)ex);
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("layoutUiEventClass", this.layoutUiEventClass);
    }
}

