/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.auditing;

import org.apache.isis.config.IsisConfiguration;

public enum DefaultViewConfiguration {
    HIDDEN("hidden"),
    TABLE("table");

    private static final String DEFAULT_VIEW_KEY = "isis.viewers.collectionLayout.defaultView";
    private final String defaultView;

    private DefaultViewConfiguration(String defaultView) {
        this.defaultView = defaultView;
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    public static DefaultViewConfiguration parse(IsisConfiguration configuration) {
        String configuredValue = configuration.getString(DEFAULT_VIEW_KEY);
        return DefaultViewConfiguration.parseValue(configuredValue);
    }

    static DefaultViewConfiguration parseValue(String value) {
        return value != null && value.trim().toLowerCase().equals("table") ? TABLE : HIDDEN;
    }
}

