/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.callbacks;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovedCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class RemoveCallbackFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"removed", "removing"};

    public RemoveCallbackFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        CallbackFacet facet;
        Class<?> cls = processClassContext.getCls();
        CallbackFacet facetHolder = processClassContext.getFacetHolder();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        ArrayList<Method> methods = new ArrayList<Method>();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "removing", Void.TYPE, NO_PARAMETERS_TYPES);
        if (method != null) {
            methods.add(method);
            facet = facetHolder.getFacet(RemovingCallbackFacet.class);
            if (facet == null) {
                facets.add(new RemovingCallbackFacetViaMethod(method, (FacetHolder)((Object)facetHolder)));
            } else {
                facet.addMethod(method);
            }
        }
        if ((method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "removed", Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            methods.add(method);
            facet = facetHolder.getFacet(RemovedCallbackFacet.class);
            if (facet == null) {
                facets.add(new RemovedCallbackFacetViaMethod(method, (FacetHolder)((Object)facetHolder)));
            } else {
                facet.addMethod(method);
            }
        }
        processClassContext.removeMethods(methods);
        FacetUtil.addFacets(facets);
    }
}

