/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.autocomplete;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.MinLengthUtil;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.publishing.PublishingServiceInternal;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;

public abstract class AutoCompleteFacetAbstract
extends FacetAbstract
implements AutoCompleteFacet {
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ObjectAdapterProvider adapterProvider;
    private final ServicesInjector servicesInjector;
    private final Class<?> repositoryClass;
    private final Method repositoryMethod;
    private Integer minLength;

    public static Class<? extends Facet> type() {
        return AutoCompleteFacet.class;
    }

    public AutoCompleteFacetAbstract(FacetHolder holder, Class<?> repositoryClass, Method repositoryMethod, ServicesInjector servicesInjector) {
        super(AutoCompleteFacetAbstract.type(), holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.repositoryClass = repositoryClass;
        this.repositoryMethod = repositoryMethod;
        this.adapterProvider = servicesInjector.getPersistenceSessionServiceInternal();
        this.servicesInjector = servicesInjector;
        this.authenticationSessionProvider = servicesInjector.getAuthenticationSessionProvider();
    }

    public Class<?> getRepositoryClass() {
        return this.repositoryClass;
    }

    @Override
    public List<ObjectAdapter> execute(final String search, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter resultAdapter = this.getPublishingServiceInternal().withPublishingSuppressed(new PublishingServiceInternal.Block<ObjectAdapter>(){

            @Override
            public ObjectAdapter exec() {
                Object list = this.invoke();
                return AutoCompleteFacetAbstract.this.adapterProvider.adapterFor(list);
            }

            private Object invoke() {
                try {
                    return AutoCompleteFacetAbstract.this.repositoryMethod.invoke(AutoCompleteFacetAbstract.this.getRepository(), search);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return Collections.emptyList();
                }
            }
        });
        if (CollectionFacet.Utils.getCollectionFacetFromSpec(resultAdapter) == null) {
            return Collections.emptyList();
        }
        Stream<ObjectAdapter> adapterList = CollectionFacet.Utils.streamAdapters(resultAdapter);
        return ObjectAdapter.Util.visibleAdapters(adapterList, interactionInitiatedBy);
    }

    private Object getRepository() {
        return this.servicesInjector.lookupService(this.repositoryClass).orElse(null);
    }

    private PublishingServiceInternal getPublishingServiceInternal() {
        return (PublishingServiceInternal)this.servicesInjector.lookupServiceElseFail(PublishingServiceInternal.class);
    }

    @Override
    public int getMinLength() {
        if (this.minLength == null) {
            this.minLength = MinLengthUtil.determineMinLength(this.repositoryMethod);
        }
        return this.minLength;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("repositoryClass", this.repositoryClass);
        attributeMap.put("repositoryMethod", this.repositoryMethod);
        attributeMap.put("minLength", this.getMinLength());
    }
}

