/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.modify;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;

public class CollectionAddToFacetViaMethod
extends CollectionAddToFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public CollectionAddToFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.MODIFY_COLLECTION_ADD;
    }

    @Override
    public void add(ObjectAdapter owningAdapter, ObjectAdapter elementAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter.InvokeUtils.invoke(this.method, (ManagedObject)owningAdapter, elementAdapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

