/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.clear;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacetAbstract;

public class CollectionClearFacetViaAccessor
extends CollectionClearFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final ObjectAdapterProvider adapterProvider;

    public CollectionClearFacetViaAccessor(Method method, FacetHolder holder, ObjectAdapterProvider adapterProvider) {
        super(holder);
        this.method = method;
        this.adapterProvider = adapterProvider;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.ACCESSOR;
    }

    @Override
    public void clear(ObjectAdapter owningAdapter) {
        Collection collection = (Collection)ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        collection.clear();
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    protected ObjectAdapterProvider getObjectAdapterProvider() {
        return this.adapterProvider;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

