/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.defaults.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacetAbstract;

public class ActionDefaultsFacetViaMethod
extends ActionDefaultsFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Method actionMethod;

    public ActionDefaultsFacetViaMethod(Method method, FacetHolder holder) {
        super(holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.method = method;
        this.actionMethod = ActionDefaultsFacetViaMethod.determineActionMethod(holder);
    }

    private static Method determineActionMethod(FacetHolder holder) {
        Method method2;
        ActionInvocationFacet actionInvocationFacet = holder.getFacet(ActionInvocationFacet.class);
        if (actionInvocationFacet instanceof ActionInvocationFacetForDomainEventAbstract) {
            ActionInvocationFacetForDomainEventAbstract facetViaMethod = (ActionInvocationFacetForDomainEventAbstract)actionInvocationFacet;
            method2 = facetViaMethod.getMethods().get(0);
        } else {
            method2 = null;
        }
        return method2;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.DEFAULTS;
    }

    @Override
    public Object[] getDefaults(ObjectAdapter owningAdapter) {
        return (Object[])ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

