/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.command;

import java.util.List;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.CommandExecuteIn;
import org.apache.isis.applib.annotation.CommandPersistence;
import org.apache.isis.applib.annotation.CommandReification;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandActionsConfiguration;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetForActionAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class CommandFacetForActionAnnotation
extends CommandFacetAbstract {
    public static CommandFacet create(List<Action> actions, IsisConfiguration configuration, ServicesInjector servicesInjector, FacetHolder holder) {
        CommandActionsConfiguration setting = CommandActionsConfiguration.parse(configuration);
        return actions.stream().filter(action -> action.command() != CommandReification.NOT_SPECIFIED).findFirst().map(action -> {
            CommandReification command = action.command();
            CommandPersistence persistence = action.commandPersistence();
            CommandExecuteIn executeIn = action.commandExecuteIn();
            Class processorClass = action.commandDtoProcessor();
            CommandDtoProcessor processor = CommandFacetForActionAnnotation.newProcessorElseNull(processorClass);
            if (processor != null) {
                command = CommandReification.ENABLED;
                persistence = CommandPersistence.PERSISTED;
            }
            switch (command) {
                case AS_CONFIGURED: {
                    switch (setting) {
                        case NONE: {
                            return null;
                        }
                        case IGNORE_SAFE: {
                            if (!CommandFacetForActionAnnotation.hasSafeSemantics(holder)) break;
                            return null;
                        }
                    }
                    return new CommandFacetForActionAnnotationAsConfigured(persistence, executeIn, CommandFacetAbstract.Enablement.ENABLED, holder, servicesInjector);
                }
                case DISABLED: {
                    return null;
                }
                case ENABLED: {
                    return new CommandFacetForActionAnnotation(persistence, executeIn, CommandFacetAbstract.Enablement.ENABLED, processor, holder, servicesInjector);
                }
            }
            throw new IllegalStateException("command '" + command + "' not recognised");
        }).orElseGet(() -> {
            switch (setting) {
                case NONE: {
                    return null;
                }
                case IGNORE_SAFE: {
                    if (!CommandFacetForActionAnnotation.hasSafeSemantics(holder)) break;
                    return null;
                }
            }
            return CommandFacetFromConfiguration.create(holder, servicesInjector);
        });
    }

    private static boolean hasSafeSemantics(FacetHolder holder) {
        ActionSemanticsFacet actionSemanticsFacet = holder.getFacet(ActionSemanticsFacet.class);
        if (actionSemanticsFacet == null) {
            throw new IllegalStateException("Require ActionSemanticsFacet in order to process");
        }
        return ((SemanticsOf)actionSemanticsFacet.value()).isSafeInNature();
    }

    CommandFacetForActionAnnotation(CommandPersistence persistence, CommandExecuteIn executeIn, CommandFacetAbstract.Enablement enablement, CommandDtoProcessor processor, FacetHolder holder, ServicesInjector servicesInjector) {
        super(persistence, executeIn, enablement, processor, holder, servicesInjector);
    }
}

