/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.events.domain.ActionDomainEvent;
import org.apache.isis.applib.services.HasUniqueId;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Collections;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actions.action.associateWith.AssociatedWithFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.command.CommandFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.hidden.HiddenFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacetDefault;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionDomainEventFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventFromActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.actions.action.prototype.PrototypeFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishedActionFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.semantics.ActionSemanticsFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.action.typeof.TypeOfFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.facets.actions.prototype.PrototypeFacet;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.members.order.annotprop.MemberOrderFacetForActionAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.ActionDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.util.EventUtil;

public class ActionAnnotationFacetFactory
extends FacetFactoryAbstract {
    public ActionAnnotationFacetFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.processInvocation(processMethodContext);
        this.processHidden(processMethodContext);
        this.processRestrictTo(processMethodContext);
        this.processSemantics(processMethodContext);
        this.processCommand(processMethodContext);
        this.processPublishing(processMethodContext);
        this.processTypeOf(processMethodContext);
        this.processAssociateWith(processMethodContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processInvocation(FacetFactory.ProcessMethodContext processMethodContext) {
        Method actionMethod = processMethodContext.getMethod();
        try {
            Class<?> returnType = actionMethod.getReturnType();
            ObjectSpecification returnSpec = this.getSpecificationLoader().loadSpecification(returnType);
            if (returnSpec == null) {
                return;
            }
            Class<?> cls = processMethodContext.getCls();
            ObjectSpecification typeSpec = this.getSpecificationLoader().loadSpecification(cls);
            Object holder = processMethodContext.getFacetHolder();
            List<Action> actions = Annotations.getAnnotations(actionMethod, Action.class);
            ActionDomainEventFacetAbstract actionDomainEventFacet = actions.stream().map(Action::domainEvent).filter(domainEvent -> domainEvent != ActionDomainEvent.Default.class).findFirst().map(domainEvent -> new ActionDomainEventFacetForActionAnnotation(ActionAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, domainEvent), this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)holder)).orElse(new ActionDomainEventFacetDefault(ActionAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, ActionDomainEvent.Default.class), this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)holder));
            if (EventUtil.eventTypeIsPostable(actionDomainEventFacet.getEventType(), ActionDomainEvent.Noop.class, ActionDomainEvent.Default.class, "isis.reflector.facet.actionAnnotation.domainEvent.postForDefault", this.getConfiguration())) {
                FacetUtil.addFacet(actionDomainEventFacet);
            }
            ActionInvocationFacetForDomainEventAbstract actionInvocationFacet = actionDomainEventFacet instanceof ActionDomainEventFacetForActionAnnotation ? new ActionInvocationFacetForDomainEventFromActionAnnotation(actionDomainEventFacet.getEventType(), actionMethod, typeSpec, returnSpec, (FacetHolder)holder, this.servicesInjector) : new ActionInvocationFacetForDomainEventFromDefault(actionDomainEventFacet.getEventType(), actionMethod, typeSpec, returnSpec, (FacetHolder)holder, this.servicesInjector);
            FacetUtil.addFacet(actionInvocationFacet);
        }
        finally {
            processMethodContext.removeMethod(actionMethod);
        }
    }

    private static Class<? extends ActionDomainEvent<?>> defaultFromDomainObjectIfRequired(ObjectSpecification typeSpec, Class<? extends ActionDomainEvent<?>> actionDomainEventType) {
        ActionDomainEventDefaultFacetForDomainObjectAnnotation typeFromDomainObject;
        if (actionDomainEventType == ActionDomainEvent.Default.class && (typeFromDomainObject = typeSpec.getFacet(ActionDomainEventDefaultFacetForDomainObjectAnnotation.class)) != null) {
            return typeFromDomainObject.getEventType();
        }
        return actionDomainEventType;
    }

    void processHidden(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Action> actions = Annotations.getAnnotations(method, Action.class);
        HiddenFacet facet = HiddenFacetForActionAnnotation.create(actions, holder);
        FacetUtil.addFacet(facet);
    }

    void processRestrictTo(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Action> actions = Annotations.getAnnotations(method, Action.class);
        PrototypeFacet facet = PrototypeFacetForActionAnnotation.create(actions, holder, _Context.getEnvironment().getDeploymentType());
        FacetUtil.addFacet(facet);
    }

    void processSemantics(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Action> actions = Annotations.getAnnotations(method, Action.class);
        ActionSemanticsFacet facet = ActionSemanticsFacetForActionAnnotation.create(actions, holder);
        FacetUtil.addFacet(facet);
    }

    void processCommand(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetHolder;
        Method method = processMethodContext.getMethod();
        List<Action> actions = Annotations.getAnnotations(method, Action.class);
        FacetedMethod holder = facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        if (HasUniqueId.class.isAssignableFrom(processMethodContext.getCls())) {
            return;
        }
        CommandFacet commandFacet = CommandFacetForActionAnnotation.create(actions, this.getConfiguration(), this.servicesInjector, holder);
        FacetUtil.addFacet(commandFacet);
    }

    void processPublishing(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        List<Action> actions = Annotations.getAnnotations(method, Action.class);
        Object holder = processMethodContext.getFacetHolder();
        if (HasUniqueId.class.isAssignableFrom(processMethodContext.getCls())) {
            return;
        }
        PublishedActionFacet facet = PublishedActionFacetForActionAnnotation.create(actions, this.getConfiguration(), holder);
        FacetUtil.addFacet(facet);
    }

    void processTypeOf(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        Class<?> methodReturnType = method.getReturnType();
        if (!_Collections.isCollectionOrArrayType(methodReturnType)) {
            return;
        }
        List<Action> actions = Annotations.getAnnotations(method, Action.class);
        TypeOfFacet typeOfFacet = actions.stream().map(Action::typeOf).filter(typeOf -> typeOf != null && typeOf != Object.class).findFirst().map(typeOf -> new TypeOfFacetForActionAnnotation((Class<?>)typeOf, this.getSpecificationLoader(), holder)).orElse(null);
        if (typeOfFacet == null) {
            Class<?> returnType = method.getReturnType();
            typeOfFacet = TypeOfFacet.Util.inferFromArrayType(holder, returnType, this.getSpecificationLoader());
        }
        if (typeOfFacet == null) {
            Class<?> cls = processMethodContext.getCls();
            typeOfFacet = TypeOfFacet.Util.inferFromGenericReturnType(cls, method, holder, this.getSpecificationLoader());
        }
        FacetUtil.addFacet(typeOfFacet);
    }

    void processAssociateWith(FacetFactory.ProcessMethodContext processMethodContext) {
        String associateWith;
        Action action;
        Method method = processMethodContext.getMethod();
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        List<Action> actions = Annotations.getAnnotations(method, Action.class);
        Action action2 = action = actions.isEmpty() ? null : actions.get(0);
        if (action != null && !_Strings.isNullOrEmpty((CharSequence)(associateWith = action.associateWith()))) {
            String associateWithSequence = action.associateWithSequence();
            FacetUtil.addFacet(new MemberOrderFacetForActionAnnotation(associateWith, associateWithSequence, holder));
            FacetUtil.addFacet(new AssociatedWithFacetForActionAnnotation(associateWith, holder));
        }
    }
}

