/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.beans.IntrospectionException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.jdo.annotations.Column;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.CollectionLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.reflection._Reflect;
import org.apache.isis.core.commons.lang.ThrowableExtensions;
import org.apache.isis.core.commons.reflection.Reflect;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public final class Annotations {
    private static List<Class<?>> fieldAnnotationClasses = _Lists.of((Object[])new Class[]{Property.class, PropertyLayout.class, Collection.class, CollectionLayout.class, Programmatic.class, MemberOrder.class, Pattern.class, Nullable.class, Title.class, XmlJavaTypeAdapter.class, XmlTransient.class, Column.class});

    private Annotations() {
    }

    public static boolean isString(Class<?> cls) {
        return cls.equals(String.class);
    }

    public static <T extends Annotation> T getDeclaredAnnotation(Class<?> cls, Class<T> annotationClass) {
        Annotation[] declaredAnnotations = cls.getDeclaredAnnotations();
        if (declaredAnnotations == null) {
            return null;
        }
        for (Annotation annotation : declaredAnnotations) {
            if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        return (T)_Reflect.getAnnotation(cls, annotationClass);
    }

    public static <T extends Annotation> List<T> getAnnotations(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (cls == null) {
            return Collections.emptyList();
        }
        ArrayList annotationAndDepths = _Lists.newArrayList();
        for (Annotation annotation : cls.getAnnotations()) {
            Annotations.append(annotation, annotationClass, annotationAndDepths);
        }
        if (!annotationAndDepths.isEmpty()) {
            return AnnotationAndDepth.sorted(annotationAndDepths);
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            try {
                List<T> annotationsFromSuperclass = Annotations.getAnnotations(superclass, annotationClass);
                if (!annotationsFromSuperclass.isEmpty()) {
                    return annotationsFromSuperclass;
                }
            }
            catch (SecurityException annotationsFromSuperclass) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            List<T> annotationsFromInterface = Annotations.getAnnotations(iface, annotationClass);
            if (annotationsFromInterface.isEmpty()) continue;
            return annotationsFromInterface;
        }
        return Collections.emptyList();
    }

    private static <T extends Annotation> void append(Annotation annotation, Class<T> annotationClass, List<AnnotationAndDepth<T>> annotationAndDepths) {
        Annotations.appendWithDepth(annotation, annotationClass, annotationAndDepths, 0, _Lists.newArrayList());
    }

    private static <T extends Annotation> void appendWithDepth(Annotation annotation, Class<T> annotationClass, List<AnnotationAndDepth<T>> annotationAndDepths, int depth, List<Annotation> visited) {
        Annotation[] annotationsOnAnnotation;
        if (visited.contains(annotation)) {
            return;
        }
        visited.add(annotation);
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationClass.isAssignableFrom(annotationType)) {
            annotationAndDepths.add(new AnnotationAndDepth<Annotation>((Annotation)_Casts.uncheckedCast((Object)annotation), depth));
        }
        for (Annotation annotationOnAnnotation : annotationsOnAnnotation = annotationType.getAnnotations()) {
            Annotations.appendWithDepth(annotationOnAnnotation, annotationClass, annotationAndDepths, depth + 1, visited);
        }
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        Class<?>[] interfaces;
        T methodAnnotation;
        Method parentClassMethod;
        T fieldAnnotation;
        Field field;
        if (method == null) {
            return null;
        }
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (Annotations.shouldSearchForField(annotationClass) && (field = Annotations.firstDeclaredField_matching(methodDeclaringClass, Annotations.isFieldForGetter(method))) != null && (fieldAnnotation = field.getAnnotation(annotationClass)) != null) {
            return fieldAnnotation;
        }
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null && (parentClassMethod = Annotations.firstDeclaredMethod_matching(method, superclass, Annotations.isSuperMethodFor(method))) != null && (methodAnnotation = Annotations.getAnnotation(parentClassMethod, annotationClass)) != null) {
            return methodAnnotation;
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            T methodAnnotation2;
            Method ifaceMethod = Annotations.firstDeclaredMethod_matching(method, iface, Annotations.isSuperMethodFor(method));
            if (ifaceMethod == null || (methodAnnotation2 = Annotations.getAnnotation(ifaceMethod, annotationClass)) == null) continue;
            return methodAnnotation2;
        }
        return null;
    }

    public static <T extends Annotation> List<T> getAnnotations(Method method, Class<T> annotationClass) {
        Class<?>[] interfaces;
        List<T> annotationsFromSuperclass;
        Method parentClassMethod;
        if (method == null) {
            return Collections.emptyList();
        }
        ArrayList annotationAndDepths = _Lists.newArrayList();
        for (Annotation annotation : method.getAnnotations()) {
            Annotations.append(annotation, annotationClass, annotationAndDepths);
        }
        if (!annotationAndDepths.isEmpty()) {
            return AnnotationAndDepth.sorted(annotationAndDepths);
        }
        if (Annotations.shouldSearchForField(annotationClass)) {
            Annotations.declaredFields_matching(method.getDeclaringClass(), Annotations.isFieldForGetter(method), field -> {
                for (Annotation annotation : field.getAnnotations()) {
                    Annotations.append(annotation, annotationClass, annotationAndDepths);
                }
            });
        }
        if (!annotationAndDepths.isEmpty()) {
            return AnnotationAndDepth.sorted(annotationAndDepths);
        }
        Class<?> superclass = method.getDeclaringClass().getSuperclass();
        if (superclass != null && (parentClassMethod = Annotations.firstDeclaredMethod_matching(method, superclass, Annotations.isSuperMethodFor(method))) != null && !(annotationsFromSuperclass = Annotations.getAnnotations(parentClassMethod, annotationClass)).isEmpty()) {
            return annotationsFromSuperclass;
        }
        for (Class<?> iface : interfaces = method.getDeclaringClass().getInterfaces()) {
            List<T> annotationsFromInterfaces;
            Method ifaceMethod = Annotations.firstDeclaredMethod_matching(method, iface, Annotations.isSuperMethodFor(method));
            if (ifaceMethod == null || (annotationsFromInterfaces = Annotations.getAnnotations(ifaceMethod, annotationClass)).isEmpty()) continue;
            return annotationsFromInterfaces;
        }
        return Collections.emptyList();
    }

    public static <T extends Annotation> List<Evaluator<T>> getEvaluators(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        ArrayList evaluators = _Lists.newArrayList();
        Annotations.visitEvaluators(cls, annotationClass, evaluators::add);
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            Annotations.visitEvaluators(iface, annotationClass, evaluators::add);
        }
        return evaluators;
    }

    public static <T extends Annotation> List<Evaluator<T>> firstEvaluatorsInHierarchyHaving(Class<?> cls, Class<T> annotationClass, Predicate<Evaluator<T>> filter) {
        ArrayList evaluators = _Lists.newArrayList();
        Annotations.visitEvaluatorsWhile(cls, annotationClass, __ -> evaluators.isEmpty(), evaluator -> {
            if (filter.test((Evaluator)evaluator)) {
                evaluators.add(evaluator);
            }
        });
        return evaluators;
    }

    private static <T extends Annotation> void visitEvaluators(Class<?> cls, Class<T> annotationClass, Consumer<Evaluator<T>> visitor) {
        Annotations.visitEvaluatorsWhile(cls, annotationClass, __ -> true, visitor);
    }

    private static <T extends Annotation> void visitEvaluatorsWhile(Class<?> cls, Class<T> annotationClass, Predicate<Class<?>> filter, Consumer<Evaluator<T>> visitor) {
        if (!filter.test(cls)) {
            return;
        }
        Annotations.visitMethodEvaluators(cls, annotationClass, visitor);
        Annotations.visitFieldEvaluators(cls, annotationClass, visitor);
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            Annotations.visitEvaluatorsWhile(superclass, annotationClass, filter, visitor);
        }
    }

    private static <T extends Annotation> void visitMethodEvaluators(Class<?> cls, Class<T> annotationClass, Consumer<Evaluator<T>> visitor) {
        for (Method method : cls.getDeclaredMethods()) {
            T annotation;
            if (!MethodScope.OBJECT.matchesScopeOf(method) || method.getParameterTypes().length != 0 || (annotation = method.getAnnotation(annotationClass)) == null) continue;
            visitor.accept(new MethodEvaluator<T>(method, annotation));
        }
    }

    private static <T extends Annotation> void visitFieldEvaluators(Class<?> cls, Class<T> annotationClass, Consumer<Evaluator<T>> visitor) {
        for (Field field : cls.getDeclaredFields()) {
            T annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            visitor.accept(new FieldEvaluator<T>(field, annotation));
        }
    }

    private static boolean shouldSearchForField(Class<?> annotationClass) {
        return fieldAnnotationClasses.contains(annotationClass);
    }

    static List<String> fieldNameCandidatesFor(String methodName) {
        if (methodName == null) {
            return Collections.emptyList();
        }
        int beginIndex = methodName.startsWith("get") ? 3 : (methodName.startsWith("is") ? 2 : -1);
        if (beginIndex == -1) {
            return Collections.emptyList();
        }
        String suffix = methodName.substring(beginIndex);
        if (suffix.length() == 0) {
            return Collections.emptyList();
        }
        char c = suffix.charAt(0);
        char lower = Character.toLowerCase(c);
        String candidate = "" + lower + suffix.substring(1);
        return Arrays.asList(candidate, "_" + candidate);
    }

    public static boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        if (method == null) {
            return false;
        }
        return _Reflect.getAnnotation((Method)method, annotationClass, (boolean)true, (boolean)true) != null;
    }

    public static <T extends Annotation> List<T> getAnnotations(Method method, int paramNum, Class<T> annotationClass) {
        Annotation[] parameterAnnotations;
        if (method == null || paramNum < 0 || paramNum >= method.getParameterCount()) {
            return Collections.emptyList();
        }
        ArrayList annotationAndDepths = _Lists.newArrayList();
        for (Annotation annotation : parameterAnnotations = method.getParameterAnnotations()[paramNum]) {
            Annotations.append(annotation, annotationClass, annotationAndDepths);
        }
        if (!annotationAndDepths.isEmpty()) {
            return AnnotationAndDepth.sorted(annotationAndDepths);
        }
        return Collections.emptyList();
    }

    private static Method firstDeclaredMethod_matching(Method method, Class<?> type, Predicate<Method> filter) {
        return _NullSafe.stream((Object[])type.getDeclaredMethods()).filter(filter).findFirst().orElse(null);
    }

    private static Field firstDeclaredField_matching(Class<?> type, Predicate<Field> filter) {
        return _NullSafe.stream((Object[])type.getDeclaredFields()).filter(filter).findFirst().orElse(null);
    }

    private static void declaredFields_matching(Class<?> type, Predicate<Field> filter, Consumer<Field> onField) {
        _NullSafe.stream((Object[])type.getDeclaredFields()).filter(filter).forEach(onField);
    }

    private static Predicate<Method> isSuperMethodFor(Method method) {
        return m -> _Reflect.same((Method)method, (Method)m);
    }

    private static Predicate<Field> isFieldForGetter(Method getter) {
        return field -> {
            int beginIndex;
            String methodName = getter.getName();
            if (methodName.startsWith("get")) {
                beginIndex = 3;
            } else if (methodName.startsWith("is")) {
                beginIndex = 2;
            } else {
                return false;
            }
            if (methodName.length() == beginIndex) {
                return false;
            }
            String suffix = methodName.substring(beginIndex);
            char c = suffix.charAt(0);
            char lower = Character.toLowerCase(c);
            String candidate = "" + lower + suffix.substring(1);
            if (field.getName().equals(candidate)) {
                return true;
            }
            return field.getName().equals("_" + candidate);
        };
    }

    public static class FieldEvaluator<T extends Annotation>
    extends Evaluator<T> {
        private final Field field;

        FieldEvaluator(Field field, T annotation) {
            super(annotation);
            this.field = field;
        }

        @Override
        protected String name() {
            return this.field.getName();
        }

        @Override
        protected MethodHandle createMethodHandle() throws IllegalAccessException {
            return Reflect.handleOf(this.field);
        }

        public Field getField() {
            return this.field;
        }

        public Optional<Method> getGetter(Class<?> originatingClass) {
            try {
                return Optional.ofNullable(Reflect.getGetter(originatingClass, this.field.getName()));
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
    }

    public static class MethodEvaluator<T extends Annotation>
    extends Evaluator<T> {
        private final Method method;

        MethodEvaluator(Method method, T annotation) {
            super(annotation);
            this.method = method;
        }

        @Override
        protected String name() {
            return this.method.getName();
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        protected MethodHandle createMethodHandle() throws IllegalAccessException {
            return Reflect.handleOf(this.method);
        }
    }

    public static abstract class Evaluator<T extends Annotation> {
        private final T annotation;
        private MethodHandle mh;

        protected Evaluator(T annotation) {
            this.annotation = annotation;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        protected abstract MethodHandle createMethodHandle() throws IllegalAccessException;

        protected abstract String name();

        public Object value(Object obj) {
            if (this.mh == null) {
                try {
                    this.mh = this.createMethodHandle();
                }
                catch (IllegalAccessException e) {
                    throw new MetaModelException("illegal access of " + this.name(), e);
                }
            }
            try {
                return this.mh.invoke(obj);
            }
            catch (Throwable e) {
                return ThrowableExtensions.handleInvocationException(e, this.name());
            }
        }
    }

    static class AnnotationAndDepth<T extends Annotation>
    implements Comparable<AnnotationAndDepth<T>> {
        T annotation;
        int depth;

        AnnotationAndDepth(T annotation, int depth) {
            this.annotation = annotation;
            this.depth = depth;
        }

        private static <T extends Annotation> List<T> sorted(List<AnnotationAndDepth<T>> annotationAndDepths) {
            Collections.sort(annotationAndDepths);
            return annotationAndDepths.stream().map(AnnotationAndDepth::getAnnotation).collect(Collectors.toList());
        }

        T getAnnotation() {
            return this.annotation;
        }

        @Override
        public int compareTo(AnnotationAndDepth<T> o) {
            return this.depth - o.depth;
        }
    }
}

