/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.version;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nullable;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.commons.lang.DateExtensions;
import org.apache.isis.core.metamodel.adapter.oid.Oid;

public class Version
implements Serializable,
Encodable {
    private static final long serialVersionUID = 1L;
    private static final Oid.Marshaller OID_MARSHALLER = Oid.marshaller();
    private final long sequence;
    private final String user;
    private final long utcTimestamp;

    public static Version empty() {
        return Factory.EMPTY_VERSION;
    }

    public static Version of(long sequence, @Nullable String user) {
        return Version.of(sequence, user, 0L);
    }

    public static Version of(long sequence, @Nullable String user, long utcTimestamp) {
        return new Version(sequence, user, utcTimestamp);
    }

    public static boolean isEmpty(Version version) {
        return version == Factory.EMPTY_VERSION;
    }

    public boolean hasTimestamp() {
        return this.utcTimestamp != 0L;
    }

    private Version(long sequence, @Nullable String user, long utcTimestamp) {
        this.sequence = sequence;
        this.user = user;
        this.utcTimestamp = utcTimestamp;
    }

    public Version(DataInputExtended input) throws IOException {
        this(input.readLong(), input.readUTF(), input.readLong());
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeLong(this.sequence);
        output.writeUTF(this.user);
        output.writeLong(this.utcTimestamp);
    }

    public long getSequence() {
        return this.sequence;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public long getUtcTimestamp() {
        return this.utcTimestamp;
    }

    @Nullable
    public Date getTime() {
        return this.utcTimestamp != 0L ? new Date(this.utcTimestamp) : null;
    }

    public String enString() {
        return OID_MARSHALLER.marshal(this);
    }

    public int hashCode() {
        return Long.hashCode(this.sequence);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.sequence == other.sequence;
    }

    public boolean different(Version version) {
        return !this.equals(version);
    }

    public String toString() {
        return "#" + this.sequence + " " + this.getUser() + " " + DateExtensions.asTimestamp(this.getTime());
    }

    public String sequence() {
        return Long.toString(this.sequence, 16);
    }

    public static final class Factory {
        private static final Version EMPTY_VERSION = null;
        private static final long EMPTY_TIMESTAMP = 0L;

        @Nullable
        public static Version ifPresent(@Nullable Long sequence, String user, @Nullable Long utcTimestamp) {
            return (Version)_With.mapIfPresentElse((Object)sequence, __ -> Version.of(sequence, user, Factory.timestampOfNullable(utcTimestamp)), (Object)EMPTY_VERSION);
        }

        @Nullable
        public static Version ifPresent(@Nullable Long sequence, String user, long utcTimestamp) {
            return (Version)_With.mapIfPresentElse((Object)sequence, __ -> Version.of(sequence, user, utcTimestamp), (Object)EMPTY_VERSION);
        }

        @Nullable
        public static Version ifPresent(@Nullable Long sequence, String user) {
            return (Version)_With.mapIfPresentElse((Object)sequence, __ -> Version.of(sequence, user, 0L), (Object)EMPTY_VERSION);
        }

        @Nullable
        public static Version parse(@Nullable String sequence, String user, @Nullable String utcTimestamp) {
            return (Version)_With.mapIfPresentElse((Object)sequence, __ -> Version.of(Long.parseLong(sequence), user, Factory.parseTimeStamp(utcTimestamp)), (Object)EMPTY_VERSION);
        }

        private static long parseTimeStamp(@Nullable String utcTimestamp) {
            return utcTimestamp != null ? Long.parseLong(utcTimestamp) : 0L;
        }

        private static long timestampOfNullable(@Nullable Long utcTimestamp) {
            return utcTimestamp != null ? utcTimestamp : 0L;
        }
    }
}

