/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.apache.isis.applib.util.Enums;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.resources._Resources;

public final class StringExtensions {
    private static final char CARRIAGE_RETURN = '\n';
    private static final char LINE_FEED = '\r';

    private StringExtensions() {
    }

    public static String asNaturalName2(String name) {
        return _Strings.asNaturalName2.apply(name);
    }

    public static String asNaturalName(String extendee) {
        int pos;
        for (pos = 0; pos < extendee.length() && Character.isLowerCase(extendee.charAt(pos)); ++pos) {
        }
        if (pos == extendee.length()) {
            return "invalid name";
        }
        return StringExtensions.naturalized(extendee, pos);
    }

    public static String asNaturalized(String extendee) {
        return StringExtensions.naturalized(extendee, 0);
    }

    private static String naturalized(String name, int startingPosition) {
        if (name.length() <= startingPosition) {
            throw new IllegalArgumentException("string shorter than starting position provided");
        }
        StringBuffer s = new StringBuffer(name.length() - startingPosition);
        for (int j = startingPosition; j < name.length(); ++j) {
            if (j > startingPosition && StringExtensions.isStartOfNewWord(name.charAt(j), name.charAt(j - 1))) {
                s.append(' ');
            }
            if (j == startingPosition) {
                s.append(Character.toUpperCase(name.charAt(j)));
                continue;
            }
            s.append(name.charAt(j));
        }
        String str = s.toString();
        return str;
    }

    private static boolean isStartOfNewWord(char c, char previousChar) {
        return Character.isUpperCase(c) || Character.isDigit(c) && !Character.isDigit(previousChar);
    }

    public static String asCamel(String extendee) {
        StringBuffer b = new StringBuffer(extendee.length());
        StringTokenizer t = new StringTokenizer(extendee);
        b.append(t.nextToken());
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            b.append(token.substring(0, 1).toUpperCase());
            b.append(token.substring(1));
        }
        return b.toString();
    }

    public static String asCamelLowerFirst(String extendee) {
        StringBuffer b = new StringBuffer(extendee.length());
        StringTokenizer t = new StringTokenizer(extendee);
        b.append(StringExtensions.asLowerFirst(t.nextToken()));
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            b.append(token.substring(0, 1).toUpperCase());
            b.append(token.substring(1).toLowerCase());
        }
        return b.toString();
    }

    public static String asLowerDashed(String extendee) {
        return _Strings.asLowerDashed.apply(extendee);
    }

    public static String asPascal(String extendee) {
        return StringExtensions.capitalize(StringExtensions.asCamel(extendee));
    }

    public static String capitalize(String extendee) {
        return _Strings.capitalize((String)extendee);
    }

    public static String asLowerFirst(String extendee) {
        if (_Strings.isNullOrEmpty((CharSequence)extendee)) {
            return extendee;
        }
        if (extendee.length() == 1) {
            return extendee.toLowerCase();
        }
        return extendee.substring(0, 1).toLowerCase() + extendee.substring(1);
    }

    public static boolean in(String extendee, String[] strings) {
        for (String strCandidate : strings) {
            if (!strCandidate.equals(extendee)) continue;
            return true;
        }
        return false;
    }

    public static List<String> splitOnCommas(String commaSeparatedExtendee) {
        if (commaSeparatedExtendee == null) {
            return null;
        }
        String removeLeadingWhiteSpace = StringExtensions.removeLeadingWhiteSpace(commaSeparatedExtendee);
        if (removeLeadingWhiteSpace.length() == 0) {
            return Collections.emptyList();
        }
        String[] splitAsArray = removeLeadingWhiteSpace.split("\\W*,\\W*");
        return Arrays.asList(splitAsArray);
    }

    public static String lineSeparated(String extendee) {
        StringBuilder buf = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        boolean lastWasLineFeed = false;
        for (char c : extendee.toCharArray()) {
            boolean isCarriageReturn;
            boolean isLineFeed = c == '\r';
            boolean bl = isCarriageReturn = c == '\n';
            if (isCarriageReturn) {
                buf.append(lineSeparator);
                lastWasLineFeed = false;
                continue;
            }
            if (lastWasLineFeed) {
                buf.append('\r');
            }
            if (isLineFeed) {
                lastWasLineFeed = true;
                continue;
            }
            buf.append(c);
            lastWasLineFeed = false;
        }
        if (lastWasLineFeed) {
            buf.append('\r');
        }
        return buf.toString();
    }

    public static String removeLeadingWhiteSpace(String extendee) {
        if (extendee == null) {
            return null;
        }
        return extendee.replaceAll("^\\W*", "");
    }

    public static String stripNewLines(String extendee) {
        return extendee.replaceAll("[\r\n]", "");
    }

    public static String stripLeadingSlash(String extendee) {
        if (!extendee.startsWith("/")) {
            return extendee;
        }
        if (extendee.length() < 2) {
            return "";
        }
        return extendee.substring(1);
    }

    public static String normalized(@Nullable String extendee) {
        return _Strings.asNormalized.apply(extendee);
    }

    public static String removePrefix(String extendee, String prefix) {
        return extendee.startsWith(prefix) ? extendee.substring(prefix.length()) : extendee;
    }

    public static String enumTitle(String enumName) {
        return Enums.getFriendlyNameOf((String)enumName);
    }

    public static String enumDeTitle(String enumFriendlyName) {
        return Enums.getEnumNameFromFriendly((String)enumFriendlyName);
    }

    public static String toAbbreviation(String extendee) {
        StringBuilder buf = new StringBuilder();
        for (char c : extendee.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean startsWith(String extendee, String prefix) {
        int length = prefix.length();
        if (length >= extendee.length()) {
            return false;
        }
        char startingCharacter = extendee.charAt(length);
        return extendee.startsWith(prefix) && Character.isUpperCase(startingCharacter);
    }

    public static String combinePath(String extendee, String suffix) {
        return _Resources.combinePath((String)extendee, (String)suffix);
    }

    public static String asJavaBaseName(String javaName) {
        int pos;
        int len = javaName.length();
        for (pos = 0; pos < len && javaName.charAt(pos) != '_' && Character.isLowerCase(javaName.charAt(pos)); ++pos) {
        }
        if (pos >= len) {
            return "";
        }
        if (javaName.charAt(pos) == '_') {
            ++pos;
        }
        if (pos >= len) {
            return "";
        }
        String baseName = javaName.substring(pos);
        char firstChar = baseName.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return Character.toUpperCase(firstChar) + baseName.substring(1);
        }
        return baseName;
    }

    public static String asJavaBaseNameStripAccessorPrefixIfRequired(String javaNameExtendee) {
        if (javaNameExtendee.startsWith("is") || javaNameExtendee.startsWith("get")) {
            return StringExtensions.asJavaBaseName(javaNameExtendee);
        }
        return StringExtensions.asCapitalizedName(javaNameExtendee);
    }

    public static String asCapitalizedName(String extendee) {
        return Character.toUpperCase(extendee.charAt(0)) + extendee.substring(1);
    }

    public static String asPluralName(String extendee) {
        String pluralName = extendee.endsWith("y") ? extendee.substring(0, extendee.length() - 1) + "ies" : (extendee.endsWith("s") || extendee.endsWith("x") ? extendee + "es" : extendee + 's');
        return pluralName;
    }

    public static String toCamelCase(String extendee) {
        String nameLower = extendee.toLowerCase();
        StringBuilder buf = new StringBuilder();
        boolean capitalizeNext = false;
        for (int i = 0; i < nameLower.length(); ++i) {
            char ch = nameLower.charAt(i);
            if (ch == '_') {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                buf.append(Character.toUpperCase(ch));
            } else {
                buf.append(ch);
            }
            capitalizeNext = false;
        }
        return buf.toString();
    }
}

