/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.commons.lang.MethodInvocationPreprocessor;
import org.apache.isis.core.commons.lang.ThrowableExtensions;

public class MethodExtensions {
    private MethodExtensions() {
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static Object invoke(Method method, Object object) {
        Object[] parameters = MethodExtensions.getNullOrDefaultArgs(method);
        return MethodExtensions.invoke(method, object, parameters);
    }

    public static Object invoke(Method method, Object object, Object[] arguments) {
        try {
            Object[] defaultAnyPrimitive = MethodExtensions.defaultAnyPrimitive(method.getParameterTypes(), arguments);
            return MethodInvocationPreprocessor.invoke(method, object, defaultAnyPrimitive);
        }
        catch (Exception e) {
            return ThrowableExtensions.handleInvocationException(e, method.getName());
        }
    }

    private static Object[] defaultAnyPrimitive(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes == null || arguments == null || parameterTypes.length != arguments.length) {
            return arguments;
        }
        Object[] argumentsWithPrimitivesDefaulted = new Object[arguments.length];
        for (int i = 0; i < argumentsWithPrimitivesDefaulted.length; ++i) {
            argumentsWithPrimitivesDefaulted[i] = MethodExtensions.valueIfPrimitiveThenDefaulted(parameterTypes[i], arguments[i]);
        }
        return argumentsWithPrimitivesDefaulted;
    }

    private static Object valueIfPrimitiveThenDefaulted(Class<?> cls, Object argument) {
        if (argument != null) {
            return argument;
        }
        if (!cls.isPrimitive()) {
            return argument;
        }
        return ClassUtil.defaultByPrimitiveClass.get(cls);
    }

    public static Object invokeStatic(Method method, Object[] parameters) {
        return MethodExtensions.invoke(method, null, parameters);
    }

    public static Object invokeStatic(Method method) {
        return MethodExtensions.invoke(method, null, MethodExtensions.getNullOrDefaultArgs(method));
    }

    public static Object[] getNullOrDefaultArgs(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] parameters = new Object[paramTypes.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = ClassExtensions.getNullOrDefault(paramTypes[i]);
        }
        return parameters;
    }
}

