/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.security.authorization.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.commons.components.InstallerAbstract;
import org.apache.isis.core.security.authorization.manager.AuthorizationManager;
import org.apache.isis.core.security.authorization.manager.AuthorizationManagerInstaller;
import org.apache.isis.core.security.authorization.standard.Authorizor;

public abstract class AuthorizationManagerStandardInstallerAbstract
extends InstallerAbstract
implements AuthorizationManagerInstaller {
    public AuthorizationManagerStandardInstallerAbstract(String name) {
        super(name);
    }

    @Override
    public AuthorizationManager createAuthorizationManager() {
        try {
            return this.createAuthorizationManagerReflective();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to create AuthorizationManager reflective", e);
        }
    }

    private AuthorizationManager createAuthorizationManagerReflective() throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InstantiationException {
        String authorizationManagerStandardClsName = "org.apache.isis.core.runtime.authorization.standard.AuthorizationManagerStandard";
        Class cls = (Class)_Casts.uncheckedCast((Object)_Context.loadClassAndInitialize((String)"org.apache.isis.core.runtime.authorization.standard.AuthorizationManagerStandard"));
        AuthorizationManager authorizationManager = (AuthorizationManager)cls.newInstance();
        Authorizor authorizor = this.createAuthorizor();
        Method setter = cls.getDeclaredMethod("setAuthorizor", Authorizor.class);
        setter.setAccessible(true);
        setter.invoke((Object)authorizationManager, authorizor);
        setter.setAccessible(false);
        return authorizationManager;
    }

    protected abstract Authorizor createAuthorizor();

    public List<Class<?>> getTypes() {
        return AuthorizationManagerStandardInstallerAbstract.listOf((Class[])new Class[]{AuthorizationManager.class});
    }
}

