/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.security.authentication.standard;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.security.authentication.AuthenticationRequest;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.core.security.authentication.manager.RegistrationDetails;
import org.apache.isis.core.security.authentication.standard.Authenticator;
import org.apache.isis.core.security.authentication.standard.AuthenticatorFuncs;
import org.apache.isis.core.security.authentication.standard.NoAuthenticatorException;
import org.apache.isis.core.security.authentication.standard.RandomCodeGenerator;
import org.apache.isis.core.security.authentication.standard.RandomCodeGenerator10Chars;
import org.apache.isis.core.security.authentication.standard.Registrar;

public class AuthenticationManagerStandard
implements AuthenticationManager {
    private final Map<String, String> userByValidationCode = _Maps.newHashMap();
    private final List<Authenticator> authenticators = _Lists.newArrayList();
    private RandomCodeGenerator randomCodeGenerator;
    private static final ToString<AuthenticationManagerStandard> toString = ToString.toString((String)"class", obj -> obj.getClass().getSimpleName()).thenToString("authenticators", obj -> "" + obj.authenticators.size()).thenToString("users", obj -> "" + obj.userByValidationCode.size());

    @Override
    @Programmatic
    public final void init() {
        this.defaultRandomCodeGeneratorIfNecessary();
        this.addDefaultAuthenticators();
        if (this.authenticators.size() == 0) {
            throw new IsisException("No authenticators specified");
        }
        for (Authenticator authenticator : this.authenticators) {
            authenticator.init();
        }
    }

    private void defaultRandomCodeGeneratorIfNecessary() {
        if (this.randomCodeGenerator == null) {
            this.randomCodeGenerator = new RandomCodeGenerator10Chars();
        }
    }

    protected void addDefaultAuthenticators() {
    }

    @Override
    @Programmatic
    public void shutdown() {
        for (Authenticator authenticator : this.authenticators) {
            authenticator.shutdown();
        }
    }

    @Override
    @Programmatic
    public final synchronized AuthenticationSession authenticate(AuthenticationRequest request) {
        if (request == null) {
            return null;
        }
        List compatibleAuthenticators = _Lists.filter(this.authenticators, AuthenticatorFuncs.compatibleWith(request));
        if (compatibleAuthenticators.size() == 0) {
            throw new NoAuthenticatorException("No authenticator available for processing " + request.getClass().getName());
        }
        for (Authenticator authenticator : compatibleAuthenticators) {
            AuthenticationSession authSession = authenticator.authenticate(request, this.getUnusedRandomCode());
            if (authSession == null) continue;
            this.userByValidationCode.put(authSession.getValidationCode(), authSession.getUserName());
            return authSession;
        }
        return null;
    }

    private String getUnusedRandomCode() {
        String code;
        while (this.userByValidationCode.containsKey(code = this.randomCodeGenerator.generateRandomCode())) {
        }
        return code;
    }

    @Override
    @Programmatic
    public final boolean isSessionValid(AuthenticationSession session) {
        String userName = this.userByValidationCode.get(session.getValidationCode());
        return session.hasUserNameOf(userName);
    }

    @Override
    @Programmatic
    public void closeSession(AuthenticationSession session) {
        List<Authenticator> authenticators = this.getAuthenticators();
        for (Authenticator authenticator : authenticators) {
            authenticator.logout(session);
        }
        this.userByValidationCode.remove(session.getValidationCode());
    }

    @Programmatic
    public final void addAuthenticator(Authenticator authenticator) {
        this.authenticators.add(authenticator);
    }

    @Programmatic
    public void addAuthenticatorToStart(Authenticator authenticator) {
        this.authenticators.add(0, authenticator);
    }

    @Programmatic
    public List<Authenticator> getAuthenticators() {
        return Collections.unmodifiableList(this.authenticators);
    }

    @Override
    @Programmatic
    public boolean register(RegistrationDetails registrationDetails) {
        for (Registrar registrar : this.getRegistrars()) {
            if (!registrar.canRegister(registrationDetails.getClass())) continue;
            return registrar.register(registrationDetails);
        }
        return false;
    }

    @Override
    @Programmatic
    public boolean supportsRegistration(Class<? extends RegistrationDetails> registrationDetailsClass) {
        for (Registrar registrar : this.getRegistrars()) {
            if (!registrar.canRegister(registrationDetailsClass)) continue;
            return true;
        }
        return false;
    }

    @Programmatic
    public List<Registrar> getRegistrars() {
        return AuthenticationManagerStandard.asAuthenticators(this.getAuthenticators());
    }

    private static List<Registrar> asAuthenticators(List<Authenticator> authenticators2) {
        return _NullSafe.stream(authenticators2).map(Registrar.AS_REGISTRAR_ELSE_NULL).filter(Registrar.NON_NULL).collect(Collectors.toList());
    }

    @Programmatic
    public void setRandomCodeGenerator(RandomCodeGenerator randomCodeGenerator) {
        assert (randomCodeGenerator != null);
        this.randomCodeGenerator = randomCodeGenerator;
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    protected IsisConfiguration getConfiguration() {
        return _Config.getConfiguration();
    }
}

