/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.plugins.classdiscovery.reflections;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.plugins.classdiscovery.ClassDiscovery;
import org.reflections.Reflections;

class ReflectDiscovery
implements ClassDiscovery {
    private final Reflections reflections;

    public static ReflectDiscovery of(List<String> packagePrefixes) {
        return new ReflectDiscovery(packagePrefixes);
    }

    public static ReflectDiscovery of(String packageNamePrefix) {
        return new ReflectDiscovery(packageNamePrefix);
    }

    public static ReflectDiscovery of(Object ... params) {
        return new ReflectDiscovery(params);
    }

    private ReflectDiscovery(Object ... params) {
        this.reflections = new Reflections(params);
    }

    @NotNull
    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        Objects.requireNonNull(annotation);
        return this.streamTypesAnnotatedWith(annotation).collect(Collectors.toCollection(HashSet::new));
    }

    @NotNull
    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Objects.requireNonNull(type);
        return this.streamSubTypesOf(type).collect(Collectors.toCollection(HashSet::new));
    }

    private Stream<Class<?>> streamTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return _NullSafe.stream((Collection)this.reflections.getTypesAnnotatedWith(annotation)).filter(_NullSafe::isPresent);
    }

    private <T> Stream<Class<? extends T>> streamSubTypesOf(Class<T> type) {
        return _NullSafe.stream((Collection)this.reflections.getSubTypesOf(type)).filter(_NullSafe::isPresent);
    }
}

