/*
 * Decompiled with CFR 0.152.
 */
package net.ftlines.wicketsource;

import java.io.Serializable;
import net.ftlines.wicketsource.AttributeModifyingInstantiationListener;
import net.ftlines.wicketsource.WicketSourceFilter;
import org.apache.wicket.Component;
import org.apache.wicket.markup.MarkupException;

public class InstantiationLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StackTraceElement traceElement;

    public InstantiationLocation(Component component) throws AttributeModifyingInstantiationListener.UnsupportedComponentException {
        this.traceElement = WicketSourceFilter.findCreationSource((Throwable)new MarkupException("constructed"), component);
        if (this.traceElement == null) {
            throw new AttributeModifyingInstantiationListener.UnsupportedComponentException(component.getId());
        }
    }

    public String getComponentType(Component component) {
        return WicketSourceFilter.getClassName(component);
    }

    private String getPackageLocation() {
        if (this.traceElement.getClassName().indexOf(46) == -1) {
            return "";
        }
        return this.traceElement.getClassName().substring(0, this.traceElement.getClassName().lastIndexOf(46));
    }

    private String getClassLocation() {
        if (this.traceElement.getClassName().indexOf(46) == -1) {
            return this.traceElement.getClassName();
        }
        return this.traceElement.getClassName().substring(this.traceElement.getClassName().lastIndexOf(46) + 1);
    }

    private String getFilename() {
        return this.traceElement.getFileName();
    }

    private Integer getLineNumber() {
        return this.traceElement.getLineNumber();
    }

    public String generateSourceLocationAttribute() {
        return this.getPackageLocation() + ":" + this.getFilename() + ":" + this.getLineNumber();
    }

    public String toString() {
        return "InstantiationLocation: packageLocation=" + this.getPackageLocation() + ", classLocation=" + this.getClassLocation() + ", lineNumber=" + this.getLineNumber();
    }
}

