/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.datanucleus.store.types.converters.TypeConverter;

public class BufferedImageByteBufferConverter
implements TypeConverter<BufferedImage, ByteBuffer> {
    private static final long serialVersionUID = 585211414298721468L;

    @Override
    public ByteBuffer toDatastoreType(BufferedImage memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            ImageIO.write((RenderedImage)memberValue, "jpg", baos);
            bytes = baos.toByteArray();
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public BufferedImage toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null || datastoreValue.limit() == 0) {
            return null;
        }
        BufferedImage obj = null;
        byte[] dataStoreValueInBytes = new byte[datastoreValue.remaining()];
        datastoreValue.get(dataStoreValueInBytes);
        try {
            obj = ImageIO.read(new ByteArrayInputStream(dataStoreValueInBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return obj;
    }
}

