/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.compiler.Symbol;
import org.datanucleus.query.compiler.SymbolResolver;
import org.datanucleus.util.StringUtils;

public class SymbolTable
implements Serializable {
    private static final long serialVersionUID = -4839286733223290900L;
    SymbolTable parentSymbolTable = null;
    Map<String, Symbol> symbols = new HashMap<String, Symbol>();
    transient SymbolResolver resolver;

    public void setSymbolResolver(SymbolResolver resolver) {
        this.resolver = resolver;
    }

    public SymbolResolver getSymbolResolver() {
        return this.resolver;
    }

    public void setParentSymbolTable(SymbolTable tbl) {
        this.parentSymbolTable = tbl;
    }

    public SymbolTable getParentSymbolTable() {
        return this.parentSymbolTable;
    }

    public Collection<String> getSymbolNames() {
        return Collections.unmodifiableCollection(this.symbols.keySet());
    }

    public Symbol getSymbol(String name) {
        if (this.symbols.containsKey(name)) {
            return this.symbols.get(name);
        }
        if (this.parentSymbolTable != null && !name.equals("this")) {
            return this.parentSymbolTable.getSymbol(name);
        }
        return null;
    }

    public Symbol getSymbolIgnoreCase(String name) {
        for (Map.Entry<String, Symbol> symbolEntry : this.symbols.entrySet()) {
            String key = symbolEntry.getKey();
            if (!key.equalsIgnoreCase(name)) continue;
            return symbolEntry.getValue();
        }
        if (this.parentSymbolTable != null && !name.equals("this")) {
            return this.parentSymbolTable.getSymbolIgnoreCase(name);
        }
        return null;
    }

    public boolean hasSymbol(String name) {
        return this.symbols.containsKey(name);
    }

    public int addSymbol(Symbol symbol) {
        if (this.symbols.containsKey(symbol.getQualifiedName())) {
            throw new NucleusException("Symbol " + symbol.getQualifiedName() + " already exists.");
        }
        this.symbols.put(symbol.getQualifiedName(), symbol);
        return this.symbols.size();
    }

    public void removeSymbol(Symbol symbol) {
        if (!this.symbols.containsKey(symbol.getQualifiedName())) {
            throw new NucleusException("Symbol " + symbol.getQualifiedName() + " doesnt exist.");
        }
        this.symbols.remove(symbol.getQualifiedName());
    }

    public String toString() {
        return "SymbolTable : " + StringUtils.mapToString(this.symbols);
    }
}

