/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.datanucleus.identity.SingleFieldId;

public class ShortId
extends SingleFieldId<Short> {
    private short key;

    public ShortId(Class pcClass, short key) {
        super(pcClass);
        this.key = key;
        this.hashCode = this.targetClassName.hashCode() ^ key;
    }

    public ShortId(Class pcClass, Short key) {
        this(pcClass, key != null ? (short)key : (short)-1);
        this.assertKeyNotNull(key);
    }

    public ShortId(Class pcClass, String str) {
        this(pcClass, Short.parseShort(str));
        this.assertKeyNotNull(str);
    }

    public ShortId() {
    }

    public short getKey() {
        return this.key;
    }

    @Override
    public Short getKeyAsObject() {
        return this.key;
    }

    public String toString() {
        return Short.toString(this.key);
    }

    @Override
    protected boolean keyEquals(SingleFieldId obj) {
        if (obj instanceof ShortId) {
            return this.key == ((ShortId)obj).key;
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof ShortId) {
            ShortId other = (ShortId)o;
            int result = super.compare(other);
            if (result == 0) {
                return this.key - other.key;
            }
            return result;
        }
        if (o == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + o.getClass().getName());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeShort(this.key);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.key = in.readShort();
    }
}

