/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.services;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.guice.GuiceBeanProvider;
import org.apache.wicket.Application;
import org.apache.wicket.guice.GuiceInjectorHolder;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class GuiceBeanProviderWicket
implements GuiceBeanProvider {
    @Programmatic
    public <T> T lookup(Class<T> beanType) {
        Application application = Application.get();
        GuiceInjectorHolder injectorHolder = (GuiceInjectorHolder)application.getMetaData(GuiceInjectorHolder.INJECTOR_KEY);
        Injector injector = injectorHolder.getInjector();
        return (T)injector.getInstance(beanType);
    }

    @Programmatic
    public <T> T lookup(Class<T> beanType, Annotation qualifier) {
        Application application = Application.get();
        GuiceInjectorHolder injectorHolder = (GuiceInjectorHolder)application.getMetaData(GuiceInjectorHolder.INJECTOR_KEY);
        Injector injector = injectorHolder.getInjector();
        return (T)injector.getInstance(Key.get(beanType, (Annotation)qualifier));
    }
}

