/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.integration.wicket;

import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.session.SessionLoggingService;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.security.authentication.AuthenticationRequest;
import org.apache.isis.core.security.authentication.AuthenticationRequestPassword;
import org.apache.isis.core.security.authentication.AuthenticationSession;
import org.apache.isis.core.security.authentication.manager.AuthenticationManager;
import org.apache.isis.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.BookmarkedPagesModelProvider;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;

public class AuthenticatedWebSessionForIsis
extends AuthenticatedWebSession
implements BreadcrumbModelProvider,
BookmarkedPagesModelProvider {
    private static final long serialVersionUID = 1L;
    public static final String USER_ROLE = "org.apache.isis.viewer.wicket.roles.USER";
    private final BookmarkedPagesModel bookmarkedPagesModel = new BookmarkedPagesModel();
    private final BreadcrumbModel breadcrumbModel = new BreadcrumbModel();
    private AuthenticationSession authenticationSession;

    public static AuthenticatedWebSessionForIsis get() {
        return (AuthenticatedWebSessionForIsis)Session.get();
    }

    public AuthenticatedWebSessionForIsis(Request request) {
        super(request);
    }

    public synchronized boolean authenticate(String username, String password) {
        AuthenticationRequestPassword authenticationRequest = new AuthenticationRequestPassword(username, password);
        authenticationRequest.setRoles(Arrays.asList(USER_ROLE));
        this.authenticationSession = this.getAuthenticationManager().authenticate((AuthenticationRequest)authenticationRequest);
        if (this.authenticationSession != null) {
            this.log(SessionLoggingService.Type.LOGIN, username, null);
            return true;
        }
        return false;
    }

    public synchronized void invalidateNow() {
        this.getAuthenticationManager().closeSession(this.authenticationSession);
        this.getIsisSessionFactory().closeSession();
        super.invalidateNow();
    }

    public synchronized void onInvalidate() {
        super.onInvalidate();
        SessionLoggingService.CausedBy causedBy = RequestCycle.get() != null ? SessionLoggingService.CausedBy.USER : SessionLoggingService.CausedBy.SESSION_EXPIRATION;
        String userName = null;
        if (this.authenticationSession != null) {
            userName = this.authenticationSession.getUserName();
        }
        this.log(SessionLoggingService.Type.LOGOUT, userName, causedBy);
    }

    public synchronized AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public synchronized Roles getRoles() {
        if (!this.isSignedIn()) {
            return null;
        }
        List roles = this.authenticationSession.getRoles();
        return new Roles(roles.toArray(new String[roles.size()]));
    }

    public synchronized void detach() {
        this.breadcrumbModel.detach();
        super.detach();
    }

    public BreadcrumbModel getBreadcrumbModel() {
        return this.breadcrumbModel;
    }

    public BookmarkedPagesModel getBookmarkedPagesModel() {
        return this.bookmarkedPagesModel;
    }

    protected AuthenticationManager getAuthenticationManager() {
        return this.getIsisSessionFactory().getAuthenticationManager();
    }

    private void log(SessionLoggingService.Type type, String username, SessionLoggingService.CausedBy causedBy) {
        IsisSessionFactory isisSessionFactory = this.getIsisSessionFactoryIfAny();
        SessionLoggingService sessionLoggingService = this.getSessionLoggingService();
        Runnable loggingTask = () -> {
            int sessionHashCode = System.identityHashCode((Object)this);
            sessionLoggingService.log(type, username, Clock.getTimeAsDateTime().toDate(), causedBy, Integer.toString(sessionHashCode));
        };
        if (isisSessionFactory != null) {
            isisSessionFactory.doInSession(loggingTask);
        } else {
            loggingTask.run();
        }
    }

    @NotNull
    protected SessionLoggingService getSessionLoggingService() {
        try {
            SessionLoggingService service = this.getIsisSessionFactory().getServicesInjector().lookupService(SessionLoggingService.class).orElseGet(SessionLoggingService.Stderr::new);
            return service;
        }
        catch (Exception e) {
            return new SessionLoggingService.Stderr();
        }
    }

    public synchronized void replaceSession() {
    }

    private IsisSessionFactory getIsisSessionFactory() {
        return IsisContext.getSessionFactory();
    }

    private IsisSessionFactory getIsisSessionFactoryIfAny() {
        try {
            return this.getIsisSessionFactory();
        }
        catch (Exception e) {
            return null;
        }
    }
}

