/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.integration.isis;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;

public class IsisInjectModule
extends AbstractModule {
    protected void configure() {
        this.bind(IsisConfiguration.class).toProvider(_Config::getConfiguration);
    }

    @Provides
    @Inject
    @Singleton
    protected IsisSessionFactory provideIsisSessionFactory(IsisConfiguration isisConfiguration) {
        AppManifest appManifest = isisConfiguration.getAppManifest();
        IsisComponentProvider componentProvider = IsisComponentProvider.builderUsingInstallers((AppManifest)appManifest).build();
        IsisSessionFactoryBuilder builder = new IsisSessionFactoryBuilder(componentProvider);
        IsisSessionFactory sessionFactory = builder.buildSessionFactory();
        return sessionFactory;
    }

    @Provides
    @Inject
    @Singleton
    protected ServicesInjector provideServicesInjector(IsisSessionFactory isisSessionFactory) {
        return isisSessionFactory.getServicesInjector();
    }
}

