/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.imagecache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.ClassUtil;

final class ImageResourceCacheKey
implements Serializable {
    private final Class<?> resourceClass;
    private final String resourceName;
    private final String toString;

    ImageResourceCacheKey(Class<?> resourceClass, String resourceName) {
        this.resourceName = resourceName;
        this.resourceClass = resourceClass;
        this.toString = this.calcToString();
    }

    public final Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public final String getResourceName() {
        return this.resourceName;
    }

    ImageResourceCacheKey superKey() {
        if (this.resourceClass == null) {
            return null;
        }
        Class<?> superclass = this.resourceClass.getSuperclass();
        if (superclass == Object.class) {
            return null;
        }
        return new ImageResourceCacheKey(superclass, this.resourceName);
    }

    List<ImageResourceCacheKey> resourcePaths(String ... suffices) {
        return this.resourcePaths(Arrays.asList(suffices));
    }

    List<ImageResourceCacheKey> resourcePaths(List<String> suffices) {
        Class resourceClass;
        ArrayList resourcePaths = _Lists.newArrayList();
        boolean generated = false;
        if (this.resourceName != null && (resourceClass = ClassUtil.forNameElseNull((String)this.resourceName)) != null) {
            for (String suffix : suffices) {
                resourcePaths.add(new ImageResourceCacheKey(resourceClass, resourceClass.getSimpleName() + "." + suffix));
            }
            generated = true;
        }
        if (!generated && this.resourceClass != null) {
            ImageResourceCacheKey key;
            if (this.resourceName != null) {
                key = this;
                do {
                    for (String suffix : suffices) {
                        resourcePaths.add(new ImageResourceCacheKey(key.getResourceClass(), key.getResourceClass().getSimpleName() + "-" + this.resourceName + "." + suffix));
                    }
                    for (String suffix : suffices) {
                        resourcePaths.add(new ImageResourceCacheKey(key.getResourceClass(), this.resourceName + "." + suffix));
                    }
                } while ((key = key.superKey()) != null);
                key = this;
                do {
                    for (String suffix : suffices) {
                        resourcePaths.add(new ImageResourceCacheKey(null, key.getResourceClass().getSimpleName() + "-" + this.resourceName + "." + suffix));
                    }
                } while ((key = key.superKey()) != null);
                for (String suffix : suffices) {
                    resourcePaths.add(new ImageResourceCacheKey(null, this.resourceName + "." + suffix));
                }
            }
            key = this;
            do {
                for (String suffix : suffices) {
                    resourcePaths.add(new ImageResourceCacheKey(key.getResourceClass(), key.getResourceClass().getSimpleName() + "." + suffix));
                }
            } while ((key = key.superKey()) != null);
            key = this;
            do {
                for (String suffix : suffices) {
                    resourcePaths.add(new ImageResourceCacheKey(null, key.getResourceClass().getSimpleName() + "." + suffix));
                }
            } while ((key = key.superKey()) != null);
            generated = true;
        }
        if (!generated && this.resourceName != null) {
            for (String suffix : suffices) {
                resourcePaths.add(new ImageResourceCacheKey(null, this.resourceName + "." + suffix));
            }
        }
        for (String suffix : suffices) {
            resourcePaths.add(new ImageResourceCacheKey(null, "Default." + suffix));
        }
        return Collections.unmodifiableList(resourcePaths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageResourceCacheKey key = (ImageResourceCacheKey)o;
        return !(this.toString != null ? !this.toString.equals(key.toString) : key.toString != null);
    }

    public int hashCode() {
        return this.toString != null ? this.toString.hashCode() : 0;
    }

    public String toString() {
        return this.toString;
    }

    private String calcToString() {
        StringBuilder buf = new StringBuilder();
        if (this.resourceClass != null) {
            buf.append(this.resourceClass.getName()).append("/").append(this.resourceClass.getSimpleName());
        }
        if (buf.length() > 0) {
            buf.append("-");
        }
        if (this.resourceName != null) {
            buf.append(this.resourceName);
        }
        return buf.toString();
    }
}

