/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models.whereami;

import java.util.LinkedList;
import java.util.stream.Stream;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.util.pchain.ParentChain;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.whereami.WhereAmIModel;

class WhereAmIModelDefault
implements WhereAmIModel {
    private final LinkedList<Object> reversedChainOfParents = new LinkedList();
    private final EntityModel startOfChain;
    private static boolean isWhereAmIEnabled = true;
    private static int maxChainLength = 64;
    private static int configHash = 0;

    public WhereAmIModelDefault(EntityModel startOfChain) {
        this.startOfChain = startOfChain;
        this.overrideFromConfigIfNew(startOfChain.getPersistenceSession().getConfiguration());
        ObjectAdapter adapter = (ObjectAdapter)startOfChain.getObject();
        Object startNode = adapter.getPojo();
        ParentChain.of(arg_0 -> ((SpecificationLoader)IsisContext.getSessionFactory().getSpecificationLoader()).loadSpecification(arg_0)).streamParentChainOf(startNode, maxChainLength).forEach(this.reversedChainOfParents::addFirst);
    }

    @Override
    public EntityModel getStartOfChain() {
        return this.startOfChain;
    }

    @Override
    public boolean isShowWhereAmI() {
        if (!isWhereAmIEnabled) {
            return false;
        }
        return !this.reversedChainOfParents.isEmpty();
    }

    @Override
    public Stream<EntityModel> streamParentChainReversed() {
        if (!isWhereAmIEnabled) {
            return Stream.empty();
        }
        return this.reversedChainOfParents.stream().map(this::toEntityModel);
    }

    private EntityModel toEntityModel(Object domainObject) {
        return new EntityModel(this.startOfChain.getPersistenceSession().adapterFor(domainObject));
    }

    private void overrideFromConfigIfNew(IsisConfiguration configuration) {
        int newConfigHash = System.identityHashCode(configuration);
        if (newConfigHash == configHash) {
            return;
        }
        configHash = newConfigHash;
        isWhereAmIEnabled = configuration.getBoolean("isis.viewer.wicket.whereAmI.enabled", true);
        maxChainLength = configuration.getInteger("isis.viewer.wicket.whereAmI.maxParentChainLength", 64);
    }
}

