/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.DomainServiceLayoutFacet;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;

public class ServiceActionsModel
extends ModelAbstract<List<ObjectAdapter>> {
    private static final long serialVersionUID = 1L;
    private final DomainServiceLayout.MenuBar menuBar;

    public ServiceActionsModel(DomainServiceLayout.MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public DomainServiceLayout.MenuBar getMenuBar() {
        return this.menuBar;
    }

    protected List<ObjectAdapter> load() {
        return this.streamServiceAdapters().filter(ServiceActionsModel.with(this.menuBar)).collect(Collectors.toList());
    }

    private static Predicate<ObjectAdapter> with(DomainServiceLayout.MenuBar menuBar) {
        return input -> {
            DomainServiceLayoutFacet facet = (DomainServiceLayoutFacet)input.getSpecification().getFacet(DomainServiceLayoutFacet.class);
            return facet != null && facet.getMenuBar() == menuBar || facet == null && menuBar == DomainServiceLayout.MenuBar.PRIMARY;
        };
    }

    protected Stream<ObjectAdapter> streamServiceAdapters() {
        return this.getPersistenceSession().streamServices();
    }
}

