/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.viewer.wicket.model.models.BookmarkTreeNode;
import org.apache.isis.viewer.wicket.model.models.BookmarkTreeNodeComparator;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ModelAbstract;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class BookmarkedPagesModel
extends ModelAbstract<List<BookmarkTreeNode>> {
    private static final long serialVersionUID = 1L;
    private static final String MAX_SIZE_KEY = "isis.viewer.wicket.bookmarkedPages.maxSize";
    private static final int MAX_SIZE_DEFAULT_VALUE = 15;
    private final List<BookmarkTreeNode> rootNodes = _Lists.newArrayList();
    private transient PageParameters current;

    public void bookmarkPage(BookmarkableModel<?> bookmarkableModel) {
        BookmarkedPagesModel.cleanUpGarbage(this.rootNodes);
        PageParameters candidatePP = bookmarkableModel.getPageParametersWithoutUiHints();
        RootOid oid = BookmarkTreeNode.oidFrom(candidatePP);
        if (oid == null) {
            return;
        }
        BookmarkTreeNode rootNode = null;
        for (BookmarkTreeNode eachNode : this.rootNodes) {
            if (!eachNode.matches(bookmarkableModel)) continue;
            rootNode = eachNode;
        }
        if (rootNode != null) {
            this.rootNodes.remove(rootNode);
            this.rootNodes.add(0, rootNode);
            this.current = candidatePP;
        } else if (bookmarkableModel.hasAsRootPolicy()) {
            rootNode = BookmarkTreeNode.newRoot(bookmarkableModel);
            this.rootNodes.add(0, rootNode);
            this.current = candidatePP;
        }
        BookmarkedPagesModel.trim(this.rootNodes, this.getMaxSize());
    }

    private int getMaxSize() {
        return this.getConfiguration().getInteger(MAX_SIZE_KEY, 15);
    }

    private static void trim(List<?> list, int requiredSize) {
        int numToRetain = Math.min(list.size(), requiredSize);
        list.retainAll(list.subList(0, numToRetain));
    }

    protected List<BookmarkTreeNode> load() {
        ArrayList depthFirstGraph = _Lists.newArrayList();
        ArrayList sortedNodes = _Lists.newArrayList(this.rootNodes);
        Collections.sort(sortedNodes, new BookmarkTreeNodeComparator(this.getSpecificationLoader()));
        for (BookmarkTreeNode rootNode : sortedNodes) {
            rootNode.appendGraphTo(depthFirstGraph);
        }
        return depthFirstGraph;
    }

    public boolean isCurrent(PageParameters pageParameters) {
        return Objects.equals(this.current, pageParameters);
    }

    private static void cleanUpGarbage(List<BookmarkTreeNode> rootNodes) {
        Iterator<BookmarkTreeNode> iter = rootNodes.iterator();
        while (iter.hasNext()) {
            BookmarkTreeNode node = iter.next();
            if (node.getOidNoVer() != null) continue;
            iter.remove();
        }
    }

    public void clear() {
        this.rootNodes.clear();
        this.current = null;
    }

    public boolean isEmpty() {
        return this.rootNodes.isEmpty();
    }

    public void remove(BookmarkTreeNode rootNode) {
        this.rootNodes.remove(rootNode);
    }

    public void remove(EntityModel entityModel) {
        BookmarkTreeNode rootNode = null;
        for (BookmarkTreeNode eachNode : this.rootNodes) {
            if (!eachNode.getOidNoVerStr().equals(entityModel.getObjectAdapterMemento().toString())) continue;
            rootNode = eachNode;
        }
        if (rootNode != null) {
            this.rootNodes.remove(rootNode);
        }
    }

    protected IsisConfiguration getConfiguration() {
        return this.getIsisSessionFactory().getConfiguration();
    }
}

