/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.models;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.wicket.model.mementos.PageParameterNames;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class BookmarkTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<BookmarkTreeNode> children = _Lists.newArrayList();
    private final int depth;
    private final RootOid oidNoVer;
    private final String oidNoVerStr;
    private final PageType pageType;
    private String title;
    private PageParameters pageParameters;

    public static BookmarkTreeNode newRoot(BookmarkableModel<?> bookmarkableModel) {
        return new BookmarkTreeNode(bookmarkableModel, 0);
    }

    private BookmarkTreeNode(BookmarkableModel<?> bookmarkableModel, int depth) {
        this.pageParameters = bookmarkableModel.getPageParametersWithoutUiHints();
        RootOid oid = BookmarkTreeNode.oidFrom(this.pageParameters);
        this.oidNoVerStr = Oid.marshaller().marshalNoVersion(oid);
        this.oidNoVer = (RootOid)Oid.unmarshaller().unmarshal(this.oidNoVerStr, RootOid.class);
        PageParameterNames.OBJECT_OID.removeFrom(this.pageParameters);
        PageParameterNames.OBJECT_OID.addStringTo(this.pageParameters, this.getOidNoVerStr());
        this.title = bookmarkableModel.getTitle();
        this.pageType = bookmarkableModel instanceof EntityModel ? PageType.ENTITY : PageType.ACTION_PROMPT;
        this.depth = depth;
    }

    public RootOid getOidNoVer() {
        return this.oidNoVer;
    }

    public String getOidNoVerStr() {
        return this.oidNoVerStr;
    }

    public String getTitle() {
        return this.title;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    public PageType getPageType() {
        return this.pageType;
    }

    public List<BookmarkTreeNode> getChildren() {
        return this.children;
    }

    public BookmarkTreeNode addChild(BookmarkableModel<?> childModel) {
        BookmarkTreeNode childNode = new BookmarkTreeNode(childModel, this.depth + 1);
        this.children.add(childNode);
        return childNode;
    }

    public boolean matches(BookmarkableModel<?> candidateBookmarkableModel) {
        if (candidateBookmarkableModel instanceof EntityModel) {
            if (this.pageType != PageType.ENTITY) {
                return false;
            }
            return this.matchAndUpdateTitleFor((EntityModel)candidateBookmarkableModel);
        }
        if (candidateBookmarkableModel instanceof ActionModel) {
            if (this.pageType != PageType.ACTION_PROMPT) {
                return false;
            }
            return this.matchFor((ActionModel)candidateBookmarkableModel);
        }
        return false;
    }

    private boolean matchAndUpdateTitleFor(EntityModel candidateEntityModel) {
        String candidateOidStr = BookmarkTreeNode.oidStrFrom(candidateEntityModel);
        boolean inGraph = Objects.equals(this.oidNoVerStr, candidateOidStr);
        if (inGraph) {
            this.setTitle(candidateEntityModel.getTitle());
        }
        if (candidateEntityModel.hasAsChildPolicy()) {
            for (BookmarkTreeNode childNode : this.getChildren()) {
                inGraph = childNode.matches(candidateEntityModel) || inGraph;
            }
            if (!inGraph) {
                inGraph = this.addToGraphIfParented(candidateEntityModel);
            }
        }
        return inGraph;
    }

    private boolean matchFor(ActionModel candidateActionModel) {
        PageParameters candidatePageParameters;
        List<String> candidateArgs;
        String candidateOidStr = BookmarkTreeNode.oidStrFrom(candidateActionModel);
        if (!Objects.equals(this.oidNoVerStr, candidateOidStr)) {
            return false;
        }
        List<String> thisArgs = PageParameterNames.ACTION_ARGS.getListFrom(this.pageParameters);
        return Objects.equals(thisArgs, candidateArgs = PageParameterNames.ACTION_ARGS.getListFrom(candidatePageParameters = candidateActionModel.getPageParameters()));
    }

    private boolean addToGraphIfParented(BookmarkableModel<?> candidateBookmarkableModel) {
        boolean[] whetherAdded = new boolean[]{false};
        if (candidateBookmarkableModel instanceof EntityModel) {
            EntityModel entityModel = (EntityModel)candidateBookmarkableModel;
            ObjectAdapter candidateAdapter = (ObjectAdapter)entityModel.getObject();
            Stream<ObjectAssociation> properties = candidateAdapter.getSpecification().streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.REFERENCE_PROPERTIES);
            properties.map(objectAssoc -> {
                ObjectAdapter parentAdapter = objectAssoc.get(candidateAdapter, InteractionInitiatedBy.USER);
                return parentAdapter;
            }).filter(_NullSafe::isPresent).map(parentAdapter -> {
                Oid parentOid = parentAdapter.getOid();
                return parentOid;
            }).filter(_NullSafe::isPresent).map(parentOid -> {
                String parentOidStr = parentOid.enStringNoVersion();
                return parentOidStr;
            }).forEach(parentOidStr -> {
                if (Objects.equals(this.oidNoVerStr, parentOidStr)) {
                    this.addChild(candidateBookmarkableModel);
                    whetherAdded[0] = true;
                }
            });
        }
        return whetherAdded[0];
    }

    public void appendGraphTo(List<BookmarkTreeNode> list) {
        list.add(this);
        for (BookmarkTreeNode childNode : this.children) {
            childNode.appendGraphTo(list);
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public static RootOid oidFrom(PageParameters pageParameters) {
        String oidStr = PageParameterNames.OBJECT_OID.getStringFrom(pageParameters);
        if (oidStr == null) {
            return null;
        }
        try {
            return (RootOid)Oid.unmarshaller().unmarshal(oidStr, RootOid.class);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String oidStrFrom(BookmarkableModel<?> candidateBookmarkableModel) {
        RootOid oid = BookmarkTreeNode.oidFrom(candidateBookmarkableModel.getPageParametersWithoutUiHints());
        return oid != null ? Oid.marshaller().marshalNoVersion(oid) : null;
    }
}

