/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import java.io.Serializable;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.viewer.wicket.model.mementos.SpecUtils;

public class CollectionMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ObjectSpecId owningType;
    private final String id;
    private final String collectionId;
    private final String collectionName;
    private transient OneToManyAssociation collection;

    private static ObjectSpecification owningSpecFor(OneToManyAssociation association, IsisSessionFactory isisSessionFactory) {
        SpecificationLoader specificationLoader = isisSessionFactory.getSpecificationLoader();
        return specificationLoader.loadSpecification(association.getIdentifier().toClassIdentityString());
    }

    public CollectionMemento(OneToManyAssociation collection, IsisSessionFactory isisSessionFactory) {
        this(CollectionMemento.owningSpecFor(collection, isisSessionFactory).getSpecId(), collection.getIdentifier().toNameIdentityString(), collection);
    }

    private CollectionMemento(ObjectSpecId owningType, String id, OneToManyAssociation collection) {
        this.owningType = owningType;
        this.id = id;
        this.collection = collection;
        this.collectionId = collection.getId();
        this.collectionName = collection.getName();
    }

    public ObjectSpecId getOwningType() {
        return this.owningType;
    }

    public String getId() {
        return this.id;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public OneToManyAssociation getCollection(SpecificationLoader specificationLoader) {
        if (this.collection == null) {
            this.collection = CollectionMemento.collectionFor(this.owningType, this.id, specificationLoader);
        }
        return this.collection;
    }

    private static OneToManyAssociation collectionFor(ObjectSpecId owningType, String id, SpecificationLoader specificationLoader) {
        return (OneToManyAssociation)SpecUtils.getSpecificationFor(owningType, specificationLoader).getAssociation(id);
    }
}

