/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.links;

import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaPosition;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.wicket.markup.html.link.AbstractLink;

public class LinkAndLabel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AbstractLink link;
    private final String label;
    private final String disabledReasonIfAny;
    private final String descriptionIfAny;
    private final boolean blobOrClob;
    private final boolean prototype;
    private final String actionIdentifier;
    private final String cssClass;
    private final String cssClassFa;
    private final CssClassFaPosition cssClassFaPosition;
    private final ActionLayout.Position position;
    private final SemanticsOf semanticsOf;
    private final PromptStyle promptStyle;
    private Parameters parameters;

    public static List<LinkAndLabel> positioned(List<LinkAndLabel> entityActionLinks, ActionLayout.Position position) {
        return _Lists.filter(entityActionLinks, Predicates.positioned(position));
    }

    public static LinkAndLabel newLinkAndLabel(ObjectAdapter objectAdapter, ObjectAction objectAction, AbstractLink link, String disabledReasonIfAny, boolean blobOrClob) {
        String name = ObjectAction.Util.nameFor((ObjectAction)objectAction);
        boolean isPrototype = objectAction.isPrototype();
        String actionIdentifier = ObjectAction.Util.actionIdentifierFor((ObjectAction)objectAction);
        String description = ObjectAction.Util.descriptionOf((ObjectAction)objectAction);
        String cssClass = ObjectAction.Util.cssClassFor((ObjectAction)objectAction, (ObjectAdapter)objectAdapter);
        String cssClassFa = ObjectAction.Util.cssClassFaFor((ObjectAction)objectAction);
        CssClassFaPosition cssClassFaPosition = ObjectAction.Util.cssClassFaPositionFor((ObjectAction)objectAction);
        ActionLayout.Position actionLayoutPosition = ObjectAction.Util.actionLayoutPositionOf((ObjectAction)objectAction);
        PromptStyle promptStyle = ObjectAction.Util.promptStyleFor((ObjectAction)objectAction);
        SemanticsOf semantics = objectAction.getSemantics();
        return new LinkAndLabel(link, name, disabledReasonIfAny, description, blobOrClob, isPrototype, actionIdentifier, cssClass, cssClassFa, cssClassFaPosition, actionLayoutPosition, semantics, promptStyle, Parameters.fromParameterCount(objectAction.getParameterCount()));
    }

    private LinkAndLabel(AbstractLink link, String label, String disabledReasonIfAny, String descriptionIfAny, boolean blobOrClob, boolean prototype, String identifier, String cssClass, String cssClassFa, CssClassFaPosition cssClassFaPosition, ActionLayout.Position position, SemanticsOf semanticsOf, PromptStyle promptStyle, Parameters parameters) {
        this.link = link;
        this.label = label;
        this.disabledReasonIfAny = disabledReasonIfAny;
        this.descriptionIfAny = descriptionIfAny;
        this.blobOrClob = blobOrClob;
        this.prototype = prototype;
        this.actionIdentifier = identifier;
        this.cssClass = cssClass;
        this.cssClassFa = cssClassFa;
        this.cssClassFaPosition = cssClassFaPosition;
        this.position = position;
        this.semanticsOf = semanticsOf;
        this.promptStyle = promptStyle;
        this.parameters = parameters;
    }

    public AbstractLink getLink() {
        return this.link;
    }

    public String getLabel() {
        return this.label;
    }

    public String getReasonDisabledIfAny() {
        return this.disabledReasonIfAny;
    }

    public String getDescriptionIfAny() {
        return this.descriptionIfAny;
    }

    public boolean isBlobOrClob() {
        return this.blobOrClob;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public String getActionIdentifier() {
        return this.actionIdentifier;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public String getCssClassFa() {
        return this.cssClassFa;
    }

    public CssClassFaPosition getCssClassFaPosition() {
        return this.cssClassFaPosition;
    }

    public ActionLayout.Position getPosition() {
        return this.position;
    }

    public SemanticsOf getSemantics() {
        return this.semanticsOf;
    }

    public PromptStyle getPromptStyle() {
        return this.promptStyle;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public static class Predicates {
        public static Predicate<LinkAndLabel> positioned(ActionLayout.Position position) {
            return input -> input.getPosition() == position;
        }
    }

    public static enum Parameters {
        NO_PARAMETERS,
        TAKES_PARAMETERS;


        public static Parameters fromParameterCount(int parameterCount) {
            return parameterCount > 0 ? TAKES_PARAMETERS : NO_PARAMETERS;
        }

        public boolean isNoParameters() {
            return this == NO_PARAMETERS;
        }
    }
}

