/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import java.util.Map;
import org.apache.isis.commons.internal.base._Timing;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectAdapterContext_ServiceLookup {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectAdapterContext_ServiceLookup.class);
    private final ObjectAdapterContext objectAdapterContext;
    private final ServicesInjector servicesInjector;

    ObjectAdapterContext_ServiceLookup(ObjectAdapterContext objectAdapterContext, ServicesInjector servicesInjector) {
        this.objectAdapterContext = objectAdapterContext;
        this.servicesInjector = servicesInjector;
    }

    ObjectAdapter lookupServiceAdapterFor(RootOid rootOid) {
        ServicesByIdResource servicesByIdResource = (ServicesByIdResource)_Context.computeIfAbsent(ServicesByIdResource.class, cls -> this.initLookupResource());
        Object serviceInstance = servicesByIdResource.lookupServiceInstance(rootOid);
        if (serviceInstance == null) {
            return null;
        }
        return this.objectAdapterContext.getFactories().createRootAdapter(serviceInstance, rootOid);
    }

    private ServicesByIdResource initLookupResource() {
        this.objectAdapterContext.printContextInfo("INIT SERVICE ID LOOKUP RESOURCE");
        _Timing.StopWatch watch = _Timing.now();
        ServicesByIdResource lookupResource = new ServicesByIdResource();
        this.servicesInjector.streamServices().map(arg_0 -> ((ObjectAdapterProvider)this.objectAdapterContext.getObjectAdapterProvider()).adapterFor(arg_0)).forEach(serviceAdapter -> {
            Assert.assertFalse((String)"expected to not be 'transient'", (boolean)serviceAdapter.getOid().isTransient());
            lookupResource.servicesById.put((RootOid)serviceAdapter.getOid(), serviceAdapter.getPojo());
        });
        this.objectAdapterContext.printContextInfo("took (\u00b5s) " + watch.stop().getMicros());
        return lookupResource;
    }

    private static class ServicesByIdResource
    implements AutoCloseable {
        private final Map<RootOid, Object> servicesById = _Maps.newHashMap();

        private ServicesByIdResource() {
        }

        @Override
        public void close() {
            this.servicesById.clear();
        }

        public Object lookupServiceInstance(RootOid serviceRootOid) {
            return this.servicesById.get(serviceRootOid);
        }
    }
}

