/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence.adaptermanager;

import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.adapter.PojoAdapter;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.adaptermanager.ObjectAdapterContext;
import org.apache.isis.core.security.authentication.AuthenticationSession;

class ObjectAdapterContext_Factories
implements ObjectAdapterContext.ObjectAdapterFactories {
    private final AuthenticationSession authenticationSession;
    private final SpecificationLoader specificationLoader;
    private final PersistenceSession session;

    ObjectAdapterContext_Factories(AuthenticationSession authenticationSession, SpecificationLoader specificationLoader, PersistenceSession session) {
        this.authenticationSession = authenticationSession;
        this.specificationLoader = specificationLoader;
        this.session = session;
    }

    @Override
    public ObjectAdapter createRootAdapter(Object pojo, RootOid rootOid) {
        _With.requires((Object)rootOid, (String)"rootOid");
        return this.createAdapter(pojo, (Oid)rootOid);
    }

    @Override
    public ObjectAdapter createCollectionAdapter(Object pojo, ParentedOid collectionOid) {
        _With.requires((Object)collectionOid, (String)"collectionOid");
        return this.createAdapter(pojo, (Oid)collectionOid);
    }

    @Override
    public ObjectAdapter createCollectionAdapter(Object pojo, RootOid parentOid, OneToManyAssociation otma) {
        Assert.assertNotNull((Object)pojo);
        ParentedOid collectionOid = Oid.Factory.parentedOfOneToMany((RootOid)parentOid, (OneToManyAssociation)otma);
        ObjectAdapter collectionAdapter = this.createCollectionAdapter(pojo, collectionOid);
        return collectionAdapter;
    }

    private ObjectAdapter createAdapter(Object pojo, Oid oid) {
        return PojoAdapter.of(pojo, oid, this.authenticationSession, this.specificationLoader, this.session);
    }
}

