/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.lang.reflect.Modifier;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectInstantiationException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;

public class ObjectFactory {
    private final PersistenceSession persistenceSession;
    private final ServicesInjector servicesInjector;

    public ObjectFactory(PersistenceSession persistenceSession, ServicesInjector servicesInjector) {
        this.persistenceSession = persistenceSession;
        this.servicesInjector = servicesInjector;
    }

    public <T> T instantiate(Class<T> cls) throws ObjectInstantiationException {
        T newInstance;
        if (this.servicesInjector == null) {
            throw new IllegalStateException("ServicesInjector is not available (no open session)");
        }
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new ObjectInstantiationException("Cannot create an instance of an abstract class: " + cls);
        }
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new ObjectInstantiationException("Cannot create an instance of an abstract class: " + cls);
        }
        try {
            newInstance = cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ObjectInstantiationException((Throwable)e);
        }
        this.servicesInjector.injectServicesInto(newInstance);
        return newInstance;
    }
}

