/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.userreg;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.email.EmailService;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.applib.services.userreg.events.EmailEventAbstract;
import org.apache.isis.applib.services.userreg.events.EmailRegistrationEvent;
import org.apache.isis.applib.services.userreg.events.PasswordResetEvent;
import org.apache.isis.commons.internal.resources._Resources;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class EmailNotificationServiceDefault
implements EmailNotificationService {
    private static final long serialVersionUID = 1L;
    private static final Pattern EMAIL_PATTERN = Pattern.compile(Pattern.quote("${email}"));
    private static final Pattern CONFIRMATION_URL_PATTERN = Pattern.compile(Pattern.quote("${confirmationUrl}"));
    private static final Pattern APPLICATION_NAME_PATTERN = Pattern.compile(Pattern.quote("${applicationName}"));
    private String passwordResetTemplate;
    private String emailVerificationTemplate;
    private boolean initialized;
    @Inject
    private EmailService emailService;

    @PostConstruct
    @Programmatic
    public void init() {
        if (this.initialized) {
            return;
        }
        this.emailVerificationTemplate = this.loadResource("EmailVerificationTemplate.html");
        this.passwordResetTemplate = this.loadResource("PasswordResetTemplate.html");
        this.initialized = true;
    }

    protected String loadResource(String resourceName) {
        try {
            return _Resources.loadAsString(EmailNotificationServiceDefault.class, (String)resourceName, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            URL templateUrl = _Resources.getResourceUrl(EmailNotificationServiceDefault.class, (String)resourceName);
            throw new IllegalStateException(String.format("Unable to read resource URL '%s'", templateUrl));
        }
    }

    @Programmatic
    public boolean isConfigured() {
        return this.emailService != null && this.emailService.isConfigured();
    }

    @Programmatic
    public boolean send(EmailRegistrationEvent emailRegistrationEvent) {
        this.ensureConfigured();
        String body = this.replace(this.emailVerificationTemplate, (EmailEventAbstract)emailRegistrationEvent);
        return this.sendEmail((EmailEventAbstract)emailRegistrationEvent, body);
    }

    @Programmatic
    public boolean send(PasswordResetEvent passwordResetEvent) {
        this.ensureConfigured();
        String body = this.replace(this.passwordResetTemplate, (EmailEventAbstract)passwordResetEvent);
        return this.sendEmail((EmailEventAbstract)passwordResetEvent, body);
    }

    private void ensureConfigured() {
        if (!this.isConfigured()) {
            throw new IllegalStateException("Not configured");
        }
    }

    protected boolean sendEmail(EmailEventAbstract emailEvent, String body) {
        String subject = this.buildSubject(emailEvent);
        String to = emailEvent.getEmail();
        return this.sendEmail(to, subject, body);
    }

    protected String buildSubject(EmailEventAbstract emailEvent) {
        String subject = "[" + emailEvent.getApplicationName() + "]";
        if (emailEvent instanceof EmailRegistrationEvent) {
            subject = subject + " Please confirm your identity";
        } else if (emailEvent instanceof PasswordResetEvent) {
            subject = subject + " Password reset request";
        }
        return subject;
    }

    protected boolean sendEmail(String to, String subject, String body) {
        List<String> toList = Collections.singletonList(to);
        List cc = Collections.emptyList();
        List bcc = Collections.emptyList();
        return this.emailService.send(toList, cc, bcc, subject, body, new DataSource[0]);
    }

    protected String replace(String template, EmailEventAbstract emailEvent) {
        String message = template;
        message = EMAIL_PATTERN.matcher(message).replaceFirst(emailEvent.getEmail());
        message = CONFIRMATION_URL_PATTERN.matcher(message).replaceAll(emailEvent.getConfirmationUrl());
        message = APPLICATION_NAME_PATTERN.matcher(message).replaceAll(emailEvent.getApplicationName());
        return message;
    }
}

