/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.publish;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.PublishingChangeKind;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.metrics.MetricsService;
import org.apache.isis.applib.services.publish.PublishedObjects;
import org.apache.isis.applib.services.publish.PublisherService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacet;
import org.apache.isis.core.metamodel.services.publishing.PublishingServiceInternal;
import org.apache.isis.core.runtime.services.changes.ChangedObjectsServiceInternal;
import org.apache.isis.core.runtime.services.publish.PublishedObjectsDefault;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
@RequestScoped
public class PublishingServiceInternalDefault
implements PublishingServiceInternal {
    boolean suppress;
    @Inject
    List<PublisherService> publisherServices;
    @Inject
    ChangedObjectsServiceInternal changedObjectsServiceInternal;
    @Inject
    CommandContext commandContext;
    @Inject
    InteractionContext interactionContext;
    @Inject
    ClockService clockService;
    @Inject
    UserService userService;
    @Inject
    MetricsService metricsService;

    @Programmatic
    public void publishObjects() {
        if (this.suppress) {
            return;
        }
        HashMap changeKindByEnlistedAdapter = _Maps.newHashMap();
        changeKindByEnlistedAdapter.putAll(this.changedObjectsServiceInternal.getChangeKindByEnlistedAdapter());
        Map changeKindByPublishedAdapter = _Maps.filterKeys((Map)changeKindByEnlistedAdapter, PublishingServiceInternalDefault.isPublished(), HashMap::new);
        if (changeKindByPublishedAdapter.isEmpty()) {
            return;
        }
        int numberLoaded = this.metricsService.numberObjectsLoaded();
        int numberObjectPropertiesModified = this.changedObjectsServiceInternal.numberObjectPropertiesModified();
        PublishedObjects publishedObjects = this.newPublishedObjects(numberLoaded, numberObjectPropertiesModified, changeKindByPublishedAdapter);
        for (PublisherService publisherService : this.publisherServices) {
            publisherService.publish(publishedObjects);
        }
    }

    private PublishedObjects newPublishedObjects(int numberLoaded, int numberObjectPropertiesModified, Map<ObjectAdapter, PublishingChangeKind> changeKindByPublishedAdapter) {
        Command command = this.commandContext.getCommand();
        UUID transactionUuid = command.getUniqueId();
        String userName = this.userService.getUser().getName();
        Timestamp timestamp = this.clockService.nowAsJavaSqlTimestamp();
        Interaction interaction = this.interactionContext.getInteraction();
        int nextEventSequence = interaction.next(Interaction.Sequence.INTERACTION.id());
        return new PublishedObjectsDefault(transactionUuid, nextEventSequence, userName, timestamp, numberLoaded, numberObjectPropertiesModified, changeKindByPublishedAdapter);
    }

    @Programmatic
    public void publishAction(Interaction.Execution<?, ?> execution) {
        if (this.suppress) {
            return;
        }
        this.publishToPublisherServices(execution);
    }

    public void publishProperty(Interaction.Execution<?, ?> execution) {
        if (this.suppress) {
            return;
        }
        this.publishToPublisherServices(execution);
    }

    private void publishToPublisherServices(Interaction.Execution<?, ?> execution) {
        if (this.publisherServices == null || this.publisherServices.isEmpty()) {
            return;
        }
        for (PublisherService publisherService : this.publisherServices) {
            publisherService.publish(execution);
        }
    }

    @Programmatic
    public <T> T withPublishingSuppressed(PublishingServiceInternal.Block<T> block) {
        try {
            this.suppress = true;
            Object object = block.exec();
            return (T)object;
        }
        finally {
            this.suppress = false;
        }
    }

    private static Predicate<ObjectAdapter> isPublished() {
        return objectAdapter -> {
            PublishedObjectFacet publishedObjectFacet = (PublishedObjectFacet)objectAdapter.getSpecification().getFacet(PublishedObjectFacet.class);
            return publishedObjectFacet != null;
        };
    }
}

