/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.i18n.po;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.i18n.LocaleProvider;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.i18n.TranslationsResolver;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.runtime.services.i18n.po.PoAbstract;
import org.apache.isis.core.runtime.services.i18n.po.PoDisabled;
import org.apache.isis.core.runtime.services.i18n.po.PoReader;
import org.apache.isis.core.runtime.services.i18n.po.PoWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class TranslationServicePo
implements TranslationService {
    public static Logger LOG = LoggerFactory.getLogger(TranslationServicePo.class);
    public static final String KEY_PO_MODE = "isis.services.translation.po.mode";
    private PoAbstract po = new PoWriter(this);
    private PoReader previousPoReader;
    private PoWriter previousPoWriter;
    @Inject
    private TranslationsResolver translationsResolver;
    @Inject
    private LocaleProvider localeProvider;

    @Programmatic
    @PostConstruct
    public void init() {
        String translationMode = _Config.getConfiguration().getString(KEY_PO_MODE);
        boolean translationDisabled = TranslationService.Mode.DISABLED.matches(translationMode);
        if (translationDisabled) {
            this.po = new PoDisabled(this);
            return;
        }
        if (this.getLocaleProvider() == null || this.getTranslationsResolver() == null) {
            return;
        }
        boolean prototypeOrTest = this.isPrototypeOrTest();
        boolean forceRead = TranslationService.Mode.READ.matches(translationMode);
        if (prototypeOrTest && !forceRead) {
            return;
        }
        PoReader poReader = new PoReader(this);
        poReader.init();
        this.po = poReader;
    }

    protected boolean isPrototypeOrTest() {
        return _Context.isPrototyping();
    }

    @Programmatic
    @PreDestroy
    public void shutdown() {
        this.po.shutdown();
    }

    @Programmatic
    public String translate(String context, String text) {
        return this.po.translate(context, text);
    }

    public String translate(String context, String singularText, String pluralText, int num) {
        return this.po.translate(context, singularText, pluralText, num);
    }

    public TranslationService.Mode getMode() {
        return this.po.getMode();
    }

    @Programmatic
    public String toPot() {
        if (!this.getMode().isWrite()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        ((PoWriter)this.po).toPot(buf);
        return buf.toString();
    }

    @Programmatic
    void clearCache() {
        if (!this.getMode().isRead()) {
            return;
        }
        ((PoReader)this.po).clearCache();
    }

    @Programmatic
    public void toggleMode() {
        if (this.getMode().isRead()) {
            this.previousPoReader = (PoReader)this.po;
            this.po = this.previousPoWriter != null ? this.previousPoWriter : new PoWriter(this);
        } else {
            this.previousPoWriter = (PoWriter)this.po;
            if (this.previousPoReader != null) {
                this.previousPoReader.clearCache();
                this.po = this.previousPoReader;
            } else {
                PoReader poReader = new PoReader(this);
                poReader.init();
                this.po = poReader;
            }
        }
    }

    @Programmatic
    TranslationsResolver getTranslationsResolver() {
        return this.translationsResolver;
    }

    @Programmatic
    LocaleProvider getLocaleProvider() {
        return this.localeProvider;
    }
}

