/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.i18n.po;

import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.runtime.services.i18n.po.PoAbstract;
import org.apache.isis.core.runtime.services.i18n.po.TranslationServicePo;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PoWriter
extends PoAbstract {
    public static Logger LOG = LoggerFactory.getLogger(PoWriter.class);
    private final SortedMap<String, Block> blocksByMsgId = _Maps.newTreeMap();

    public PoWriter(TranslationServicePo translationServicePo) {
        super(translationServicePo, TranslationService.Mode.WRITE);
    }

    @Override
    void shutdown() {
        if (IsisContext.getMetaModelInvalidExceptionIfAny() != null) {
            return;
        }
        this.logTranslations();
    }

    private void logTranslations() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        buf.append("\n##############################################################################");
        buf.append("\n#");
        buf.append("\n# .pot file");
        buf.append("\n#");
        buf.append("\n# Translate this file to each required language and place in WEB-INF, eg:");
        buf.append("\n#");
        buf.append("\n#     /WEB-INF/translations-en_US.po");
        buf.append("\n#     /WEB-INF/translations-en.po");
        buf.append("\n#     /WEB-INF/translations-fr_FR.po");
        buf.append("\n#     /WEB-INF/translations-fr.po");
        buf.append("\n#     /WEB-INF/translations.po");
        buf.append("\n#");
        buf.append("\n# If the app uses TranslatableString (eg for internationalized validation");
        buf.append("\n# messages), or if the app calls the TranslationService directly, then ensure");
        buf.append("\n# that all text to be translated has been captured by running a full");
        buf.append("\n# integration test suite that exercises all relevant behaviour");
        buf.append("\n#");
        buf.append("\n##############################################################################");
        buf.append("\n");
        buf.append("\n");
        this.toPot(buf);
        buf.append("\n");
        buf.append("\n");
        buf.append("\n##############################################################################");
        buf.append("\n# end of .pot file");
        buf.append("\n##############################################################################");
        buf.append("\n");
        LOG.info(buf.toString());
    }

    protected void header(StringBuilder buf) {
        String createdAt = LocalDateTime.now().toString("yyyy-MM-dd HH:mm:ss+Z");
        buf.append("#, fuzzy").append("\n");
        buf.append("msgid \"\"").append("\n");
        buf.append("msgstr \"\"").append("\n");
        buf.append("\"Project-Id-Version: \\n\"").append("\n");
        buf.append("\"POT-Creation-Date: ").append(createdAt).append("\\n\"").append("\n");
        buf.append("\"MIME-Version: 1.0\\n\"").append("\n");
        buf.append("\"Content-Type: text/plain; charset=UTF-8\\n\"").append("\n");
        buf.append("\"Content-Transfer-Encoding: 8bit\\n\"").append("\n");
        buf.append("\"Plural-Forms: nplurals=2; plural=n != 1;\\n\"").append("\n");
        buf.append("\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String translate(String context, String msgId) {
        Block block;
        if (msgId == null) {
            return null;
        }
        Block block2 = block = this.blockFor(msgId);
        synchronized (block2) {
            block.contexts.add(context);
        }
        return msgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String translate(String context, String msgId, String msgIdPlural, int num) {
        Block block;
        if (msgId == null) {
            return null;
        }
        Block block2 = block = this.blockFor(msgId);
        synchronized (block2) {
            block.contexts.add(context);
            block.msgIdPlural = msgIdPlural;
        }
        return null;
    }

    private synchronized Block blockFor(String msgId) {
        Block block = (Block)this.blocksByMsgId.get(msgId);
        if (block == null) {
            block = new Block();
            this.blocksByMsgId.put(msgId, block);
        }
        return block;
    }

    void toPot(StringBuilder buf) {
        this.header(buf);
        for (String msgId : this.blocksByMsgId.keySet()) {
            Block block = (Block)this.blocksByMsgId.get(msgId);
            for (String context : block.contexts) {
                buf.append("#: ").append(context).append("\n");
            }
            buf.append("msgid \"").append(PoWriter.escape(msgId)).append("\"\n");
            String msgIdPlural = block.msgIdPlural;
            if (msgIdPlural == null) {
                buf.append("msgstr \"\"\n");
            } else {
                buf.append("msgid_plural \"").append(PoWriter.escape(msgIdPlural)).append("\"\n");
                buf.append("msgstr[0] \"\"\n");
                buf.append("msgstr[1] \"\"\n");
            }
            buf.append("\n\n");
        }
    }

    static String escape(String msgId) {
        return msgId.replace("\"", "\\\"");
    }

    private static class Block {
        private final SortedSet<String> contexts = _Sets.newTreeSet();
        private String msgIdPlural;

        private Block() {
        }
    }
}

