/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.changes;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.isis.core.runtime.services.changes.ChangedObjectsServiceInternal;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;

public class PreAndPostValues {
    private final Object pre;
    private final String preString;
    private Object post;
    private String postString;

    public static PreAndPostValues pre(Object preValue) {
        return new PreAndPostValues(preValue, null);
    }

    private PreAndPostValues(Object pre, Object post) {
        this.pre = pre;
        this.post = post;
        this.preString = ChangedObjectsServiceInternal.asString(pre);
    }

    public Object getPre() {
        return this.pre;
    }

    public String getPreString() {
        return this.preString;
    }

    public Object getPost() {
        return this.post;
    }

    public String getPostString() {
        return this.postString;
    }

    public void setPost(Object post) {
        this.post = post;
        this.postString = ChangedObjectsServiceInternal.asString(post);
    }

    public String toString() {
        return this.getPre() + " -> " + this.getPost();
    }

    public boolean shouldAudit() {
        if (this.getPre() == IsisTransaction.Placeholder.NEW && this.getPost() == IsisTransaction.Placeholder.DELETED) {
            return false;
        }
        if (this.getPre() == IsisTransaction.Placeholder.NEW || this.getPost() == IsisTransaction.Placeholder.DELETED) {
            return true;
        }
        return !Objects.equals(this.getPre(), this.getPost());
    }

    public static class Predicates {
        public static final Predicate<Map.Entry<?, PreAndPostValues>> SHOULD_AUDIT = input -> {
            PreAndPostValues papv = (PreAndPostValues)input.getValue();
            return papv.shouldAudit();
        };
    }
}

