/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.changes;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.RequestScoped;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.PublishingChangeKind;
import org.apache.isis.applib.services.HasUniqueId;
import org.apache.isis.applib.services.WithTransactionScope;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.concurrency.ConcurrencyChecking;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.services.changes.AdapterAndProperty;
import org.apache.isis.core.runtime.services.changes.PreAndPostValues;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
@RequestScoped
public class ChangedObjectsServiceInternal
implements WithTransactionScope {
    private final Map<AdapterAndProperty, PreAndPostValues> enlistedObjectProperties = _Maps.newLinkedHashMap();
    private Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties;
    private final Map<ObjectAdapter, PublishingChangeKind> changeKindByEnlistedAdapter = _Maps.newLinkedHashMap();

    @Programmatic
    public boolean isEnlisted(ObjectAdapter adapter) {
        return this.changeKindByEnlistedAdapter.containsKey(adapter);
    }

    @Programmatic
    public void enlistCreated(ObjectAdapter adapter) {
        if (this.shouldIgnore(adapter)) {
            return;
        }
        this.enlistForPublishing(adapter, PublishingChangeKind.CREATE);
        Stream<ObjectAssociation> properties = adapter.getSpecification().streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
        this.enlist(adapter, properties, aap -> PreAndPostValues.pre(IsisTransaction.Placeholder.NEW));
    }

    @Programmatic
    public void enlistUpdating(ObjectAdapter adapter) {
        if (this.shouldIgnore(adapter)) {
            return;
        }
        this.enlistForPublishing(adapter, PublishingChangeKind.UPDATE);
        Stream<ObjectAssociation> properties = adapter.getSpecification().streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
        this.enlist(adapter, properties, aap -> PreAndPostValues.pre(aap.getPropertyValue()));
    }

    @Programmatic
    public void enlistDeleting(ObjectAdapter adapter) {
        if (this.shouldIgnore(adapter)) {
            return;
        }
        boolean enlisted = this.enlistForPublishing(adapter, PublishingChangeKind.DELETE);
        if (!enlisted) {
            return;
        }
        Stream<ObjectAssociation> properties = adapter.getSpecification().streamAssociations(Contributed.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
        this.enlist(adapter, properties, aap -> PreAndPostValues.pre(aap.getPropertyValue()));
    }

    private boolean enlistForPublishing(ObjectAdapter adapter, PublishingChangeKind current) {
        PublishingChangeKind previous = this.changeKindByEnlistedAdapter.get(adapter);
        if (previous == null) {
            this.changeKindByEnlistedAdapter.put(adapter, current);
            return true;
        }
        switch (previous) {
            case CREATE: {
                switch (current) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.remove(adapter);
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case UPDATE: {
                switch (current) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.put(adapter, current);
                        return true;
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case DELETE: {
                return false;
            }
        }
        return previous == null;
    }

    @Programmatic
    public Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> getChangedObjectProperties() {
        return this.changedObjectProperties != null ? this.changedObjectProperties : (this.changedObjectProperties = this.capturePostValuesAndDrain(this.enlistedObjectProperties));
    }

    private Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> capturePostValuesAndDrain(Map<AdapterAndProperty, PreAndPostValues> changedObjectProperties) {
        return (Set)ConcurrencyChecking.executeWithConcurrencyCheckingDisabled(() -> {
            LinkedHashMap processedObjectProperties = _Maps.newLinkedHashMap();
            while (!changedObjectProperties.isEmpty()) {
                LinkedHashSet keys = _Sets.newLinkedHashSet(changedObjectProperties.keySet());
                for (AdapterAndProperty aap : keys) {
                    PreAndPostValues papv = (PreAndPostValues)changedObjectProperties.remove(aap);
                    ObjectAdapter adapter = aap.getAdapter();
                    if (adapter.isDestroyed()) {
                        papv.setPost(IsisTransaction.Placeholder.DELETED);
                    } else {
                        papv.setPost(aap.getPropertyValue());
                    }
                    processedObjectProperties.put(aap, papv);
                }
            }
            return Collections.unmodifiableSet(processedObjectProperties.entrySet().stream().filter(PreAndPostValues.Predicates.SHOULD_AUDIT).collect(Collectors.toSet()));
        });
    }

    protected boolean shouldIgnore(ObjectAdapter adapter) {
        ObjectSpecification adapterSpec = adapter.getSpecification();
        Class adapterClass = adapterSpec.getCorrespondingClass();
        return HasUniqueId.class.isAssignableFrom(adapterClass);
    }

    @Programmatic
    public Map<ObjectAdapter, PublishingChangeKind> getChangeKindByEnlistedAdapter() {
        return this.changeKindByEnlistedAdapter;
    }

    @Programmatic
    public int numberObjectsDirtied() {
        return this.changeKindByEnlistedAdapter.size();
    }

    @Programmatic
    public int numberObjectPropertiesModified() {
        if (this.changedObjectProperties == null) {
            this.getChangedObjectProperties();
        }
        return this.changedObjectProperties.size();
    }

    @Programmatic
    public void resetForNextTransaction() {
        this.enlistedObjectProperties.clear();
        this.changedObjectProperties = null;
    }

    static String asString(Object object) {
        return object != null ? object.toString() : null;
    }

    private void enlist(ObjectAdapter adapter, Stream<ObjectAssociation> properties, Function<AdapterAndProperty, PreAndPostValues> pre) {
        properties.filter(property -> !property.isNotPersisted()).map(property -> AdapterAndProperty.of(adapter, property)).filter(aap -> !this.enlistedObjectProperties.containsKey(aap)).forEach(aap -> this.enlistedObjectProperties.put((AdapterAndProperty)aap, (PreAndPostValues)pre.apply((AdapterAndProperty)aap)));
    }
}

